/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.remoting.bolt;

import com.alipay.remoting.Connection;
import com.alipay.remoting.ConnectionEventProcessor;
import com.alipay.remoting.ConnectionEventType;
import com.alipay.remoting.InvokeCallback;
import com.alipay.remoting.exception.RemotingException;
import com.alipay.remoting.rpc.RpcClient;
import com.alipay.remoting.rpc.protocol.UserProcessor;
import com.alipay.sofa.registry.common.model.store.URL;
import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.net.NetUtil;
import com.alipay.sofa.registry.remoting.CallbackHandler;
import com.alipay.sofa.registry.remoting.Channel;
import com.alipay.sofa.registry.remoting.ChannelHandler;
import com.alipay.sofa.registry.remoting.Client;
import com.alipay.sofa.registry.remoting.bolt.AsyncUserProcessorAdapter;
import com.alipay.sofa.registry.remoting.bolt.BoltChannel;
import com.alipay.sofa.registry.remoting.bolt.ConnectionEventAdapter;
import com.alipay.sofa.registry.remoting.bolt.SyncUserProcessorAdapter;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;

public class BoltClient
implements Client {
    private static final Logger LOGGER = LoggerFactory.getLogger(BoltClient.class);
    private RpcClient boltClient;
    private List<ChannelHandler> channelHandlers = new ArrayList<ChannelHandler>();
    private Map<String, Channel> channels = new HashMap<String, Channel>();
    private AtomicBoolean initHandler = new AtomicBoolean(false);

    public BoltClient() {
        this.boltClient = new RpcClient();
        this.boltClient.init();
    }

    public Channel connect(URL targetUrl) {
        if (targetUrl == null) {
            throw new IllegalArgumentException("Create connection targetUrl can not be null!");
        }
        InetSocketAddress address = URL.toInetSocketAddress((URL)targetUrl);
        Channel c = this.getChannel(address);
        if (c != null && c.isConnected()) {
            LOGGER.info("Target url:" + targetUrl + " has been connected!", (Object)targetUrl);
            return c;
        }
        this.initHandler();
        try {
            Connection connection = this.boltClient.getConnection(NetUtil.toAddressString((InetSocketAddress)address), 1000);
            if (connection != null) {
                BoltChannel channel = new BoltChannel();
                channel.setConnection(connection);
                this.channels.put(connection.getUrl().getOriginUrl(), channel);
                return channel;
            }
            throw new RuntimeException("Bolt client connect server get none connection!");
        }
        catch (RemotingException e) {
            LOGGER.error("Bolt client connect server got a RemotingException! target url:" + targetUrl, (Throwable)e);
            throw new RuntimeException("Bolt client connect server got a RemotingException!", e);
        }
        catch (InterruptedException e) {
            LOGGER.error("Bolt client connect server has been Interrupted!", (Throwable)e);
            throw new RuntimeException("Bolt client connect server has been Interrupted!", e);
        }
    }

    private void initHandler() {
        if (this.initHandler.compareAndSet(false, true)) {
            this.boltClient.addConnectionEventProcessor(ConnectionEventType.CONNECT, (ConnectionEventProcessor)new ConnectionEventAdapter(ConnectionEventType.CONNECT, this.getConnectionEventHandler(), null));
            this.boltClient.addConnectionEventProcessor(ConnectionEventType.CLOSE, (ConnectionEventProcessor)new ConnectionEventAdapter(ConnectionEventType.CLOSE, this.getConnectionEventHandler(), null));
            this.boltClient.addConnectionEventProcessor(ConnectionEventType.EXCEPTION, (ConnectionEventProcessor)new ConnectionEventAdapter(ConnectionEventType.EXCEPTION, this.getConnectionEventHandler(), null));
            this.registerUserProcessorHandler();
        }
    }

    private void registerUserProcessorHandler() {
        if (this.channelHandlers != null) {
            for (ChannelHandler channelHandler : this.channelHandlers) {
                if (!ChannelHandler.HandlerType.PROCESSER.equals((Object)channelHandler.getType())) continue;
                if (ChannelHandler.InvokeType.SYNC.equals((Object)channelHandler.getInvokeType())) {
                    this.boltClient.registerUserProcessor((UserProcessor)new SyncUserProcessorAdapter(channelHandler));
                    continue;
                }
                this.boltClient.registerUserProcessor((UserProcessor)new AsyncUserProcessorAdapter(channelHandler));
            }
        }
    }

    public Collection<Channel> getChannels() {
        HashSet<Channel> chs = new HashSet<Channel>();
        for (Channel channel : this.channels.values()) {
            if (channel.isConnected()) {
                chs.add(channel);
                continue;
            }
            this.channels.remove(NetUtil.toAddressString((InetSocketAddress)channel.getRemoteAddress()));
        }
        return chs;
    }

    public Channel getChannel(InetSocketAddress remoteAddress) {
        Channel c = this.channels.get(NetUtil.toAddressString((InetSocketAddress)remoteAddress));
        if (c == null || !c.isConnected()) {
            return null;
        }
        return c;
    }

    public Channel getChannel(URL url) {
        Channel c = this.channels.get(url.getAddressString());
        if (c == null || !c.isConnected()) {
            return null;
        }
        return c;
    }

    public List<ChannelHandler> getChannelHandlers() {
        return this.channelHandlers;
    }

    public void setChannelHandlers(List<ChannelHandler> channelHandlers) {
        this.channelHandlers = channelHandlers;
    }

    public InetSocketAddress getLocalAddress() {
        return NetUtil.getLocalSocketAddress();
    }

    public ChannelHandler getConnectionEventHandler() {
        if (this.channelHandlers != null) {
            for (ChannelHandler channelHandler : this.channelHandlers) {
                if (!ChannelHandler.HandlerType.LISENTER.equals((Object)channelHandler.getType())) continue;
                return channelHandler;
            }
        }
        return null;
    }

    public void close() {
        Collection<Channel> chs = this.getChannels();
        if (chs != null && chs.size() > 0) {
            for (Channel ch : chs) {
                if (ch == null) continue;
                this.boltClient.closeStandaloneConnection(((BoltChannel)ch).getConnection());
            }
        }
    }

    public void close(Channel channel) {
        if (channel != null) {
            Connection connection = ((BoltChannel)channel).getConnection();
            if (null != connection.getUrl() && null != connection.getUrl().getOriginUrl()) {
                this.channels.remove(connection.getUrl().getOriginUrl());
            }
            this.boltClient.closeStandaloneConnection(connection);
        }
    }

    public boolean isClosed() {
        boolean ret = false;
        Collection<Channel> chs = this.getChannels();
        if (chs != null && chs.size() > 0) {
            for (Channel ch : chs) {
                if (ch == null || ch.isConnected()) continue;
                ret = true;
                break;
            }
        } else {
            return true;
        }
        return ret;
    }

    public void sendOneway(Channel channel, Object message) {
        if (channel != null && channel.isConnected() && channel instanceof BoltChannel) {
            BoltChannel boltChannel = (BoltChannel)channel;
            try {
                this.boltClient.oneway(boltChannel.getConnection(), message);
            }
            catch (RemotingException e) {
                LOGGER.error("Bolt Client oneway request RemotingException! target url: {}", (Object)boltChannel.getRemoteAddress(), (Object)e);
            }
        }
    }

    public Object sendSync(Channel channel, Object message, int timeoutMillis) {
        if (channel != null && channel.isConnected()) {
            if (channel instanceof BoltChannel) {
                BoltChannel boltChannel = (BoltChannel)channel;
                try {
                    return this.boltClient.invokeSync(boltChannel.getConnection(), message, timeoutMillis);
                }
                catch (RemotingException e) {
                    LOGGER.error("Bolt Client sendSync message RemotingException! target url:" + boltChannel.getRemoteAddress(), (Throwable)e);
                    throw new RuntimeException("Bolt Client sendSync message RemotingException!", e);
                }
                catch (InterruptedException e) {
                    LOGGER.error("Bolt Client sendSync message InterruptedException! target url:" + boltChannel.getRemoteAddress(), (Throwable)e);
                    throw new RuntimeException("Bolt Client sendSync message InterruptedException!", e);
                }
            }
            throw new IllegalArgumentException("Input channel instance error! instance class:" + channel.getClass().getName());
        }
        throw new IllegalArgumentException("Input channel: " + channel + " error! channel cannot be null,or channel must be connected!");
    }

    public void sendCallback(final Channel channel, Object message, final CallbackHandler callbackHandler, int timeoutMillis) {
        if (channel != null && channel.isConnected()) {
            if (channel instanceof BoltChannel) {
                BoltChannel boltChannel = (BoltChannel)channel;
                try {
                    this.boltClient.invokeWithCallback(boltChannel.getConnection(), message, new InvokeCallback(){

                        public void onResponse(Object result) {
                            callbackHandler.onCallback(channel, result);
                        }

                        public void onException(Throwable e) {
                            callbackHandler.onException(channel, e);
                        }

                        public Executor getExecutor() {
                            return null;
                        }
                    }, timeoutMillis);
                    return;
                }
                catch (RemotingException e) {
                    LOGGER.error("Bolt Client sendSync message RemotingException! target url:" + boltChannel.getRemoteAddress(), (Throwable)e);
                    throw new RuntimeException("Bolt Client sendSync message RemotingException!", e);
                }
            }
            throw new IllegalArgumentException("Input channel instance error! instance class:" + channel.getClass().getName());
        }
        throw new IllegalArgumentException("Input channel: " + channel + " error! channel cannot be null,or channel must be connected!");
    }
}

