/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.remoting.bolt;

import com.alipay.remoting.Connection;
import com.alipay.remoting.ConnectionEventProcessor;
import com.alipay.remoting.ConnectionEventType;
import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.remoting.Channel;
import com.alipay.sofa.registry.remoting.ChannelHandler;
import com.alipay.sofa.registry.remoting.bolt.BoltChannel;
import com.alipay.sofa.registry.remoting.bolt.BoltServer;

public class ConnectionEventAdapter
implements ConnectionEventProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectionEventAdapter.class);
    private ConnectionEventType connectionEventType;
    private ChannelHandler connectionEventHandler;
    private BoltServer boltServer;

    public ConnectionEventAdapter(ConnectionEventType connectionEventType, ChannelHandler connectionEventHandler, BoltServer boltServer) {
        this.connectionEventType = connectionEventType;
        this.connectionEventHandler = connectionEventHandler;
        this.boltServer = boltServer;
    }

    public void onEvent(String remoteAddr, Connection conn) {
        try {
            if (this.connectionEventHandler != null) {
                switch (this.connectionEventType) {
                    case CONNECT: {
                        BoltChannel boltChannel = new BoltChannel();
                        boltChannel.setConnection(conn);
                        if (this.boltServer != null) {
                            this.boltServer.addChannel(boltChannel);
                        }
                        this.connectionEventHandler.connected((Channel)boltChannel);
                        break;
                    }
                    case CLOSE: {
                        BoltChannel boltChannelClose = new BoltChannel();
                        boltChannelClose.setConnection(conn);
                        if (this.boltServer != null) {
                            this.boltServer.removeChannel(boltChannelClose);
                        }
                        this.connectionEventHandler.disconnected((Channel)boltChannelClose);
                        break;
                    }
                    case EXCEPTION: {
                        BoltChannel boltChannelException = new BoltChannel();
                        boltChannelException.setConnection(conn);
                        this.connectionEventHandler.caught((Channel)boltChannelException, null, null);
                        break;
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Connection process " + this.connectionEventType + " error!", (Throwable)e);
            throw new RuntimeException("Connection process " + this.connectionEventType + " error!", e);
        }
    }
}

