/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.data.cache;

import com.alipay.sofa.registry.common.model.metaserver.DataNode;
import com.alipay.sofa.registry.server.data.bootstrap.DataServerConfig;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class BackupTriad {
    private String dataInfoId;
    private List<DataNode> triad;
    private Set<String> ipSetOfNode = new HashSet<String>();

    public BackupTriad(String dataInfoId, List<DataNode> triad) {
        this.dataInfoId = dataInfoId;
        this.triad = triad;
        for (DataNode node : triad) {
            this.ipSetOfNode.add(node.getIp());
        }
    }

    public boolean containsSelf() {
        return !this.ipSetOfNode.isEmpty() && this.ipSetOfNode.contains(DataServerConfig.IP);
    }

    public List<DataNode> getNewJoined(List<DataNode> newTriad, Set<String> notWorking) {
        ArrayList<DataNode> list = new ArrayList<DataNode>();
        for (DataNode node : newTriad) {
            String ip = node.getIp();
            if (this.ipSetOfNode.contains(ip) && !notWorking.contains(ip)) continue;
            list.add(node);
        }
        return list;
    }

    public String getDataInfoId() {
        return this.dataInfoId;
    }

    public void setDataInfoId(String dataInfoId) {
        this.dataInfoId = dataInfoId;
    }

    public List<DataNode> getTriad() {
        return this.triad;
    }

    public void setTriad(List<DataNode> triad) {
        this.triad = triad;
        HashSet<String> ipSetOfNode = new HashSet<String>();
        for (DataNode node : triad) {
            ipSetOfNode.add(node.getIp());
        }
        this.ipSetOfNode = ipSetOfNode;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("BackupTriad{");
        sb.append("dataInfoId='").append(this.dataInfoId).append('\'');
        sb.append(", ipSetOfNode=").append(this.ipSetOfNode);
        sb.append('}');
        return sb.toString();
    }
}

