/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.data.datasync.sync;

import com.alipay.sofa.registry.common.model.dataserver.SyncData;
import com.alipay.sofa.registry.common.model.dataserver.SyncDataRequest;
import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.server.data.datasync.AcceptorStore;
import com.alipay.sofa.registry.server.data.datasync.Operator;
import com.alipay.sofa.registry.server.data.datasync.SyncDataService;
import com.alipay.sofa.registry.server.data.datasync.sync.StoreServiceFactory;

public class SyncDataServiceImpl
implements SyncDataService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SyncDataServiceImpl.class, (String)"[SyncDataService]");

    @Override
    public void appendOperator(Operator operator) {
        AcceptorStore acceptorStore = StoreServiceFactory.getStoreService(operator.getSourceType().toString());
        if (acceptorStore == null) {
            LOGGER.error("Can't find acceptor store type {} to Append operator!", (Object)operator.getSourceType());
            throw new RuntimeException("Can't find acceptor store to Append operator!");
        }
        acceptorStore.addOperator(operator);
    }

    @Override
    public SyncData getSyncDataChange(SyncDataRequest syncDataRequest) {
        AcceptorStore acceptorStore = StoreServiceFactory.getStoreService(syncDataRequest.getDataSourceType());
        if (acceptorStore != null) {
            return acceptorStore.getSyncData(syncDataRequest);
        }
        LOGGER.error("Can't find acceptor store type {} to get sync Data!", (Object)syncDataRequest.getDataSourceType());
        throw new RuntimeException("Can't find acceptor store to get sync Data!");
    }
}

