/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.data.remoting;

import com.alipay.sofa.registry.common.model.store.URL;
import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.remoting.Channel;
import com.alipay.sofa.registry.remoting.ChannelHandler;
import com.alipay.sofa.registry.remoting.Client;
import com.alipay.sofa.registry.remoting.exchange.Exchange;
import com.alipay.sofa.registry.remoting.exchange.NodeExchanger;
import com.alipay.sofa.registry.remoting.exchange.message.Request;
import com.alipay.sofa.registry.remoting.exchange.message.Response;
import com.alipay.sofa.registry.server.data.bootstrap.DataServerConfig;
import com.alipay.sofa.registry.server.data.remoting.handler.AbstractClientHandler;
import java.util.Collection;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;

public class DataNodeExchanger
implements NodeExchanger {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataNodeExchanger.class);
    @Autowired
    private Exchange boltExchange;
    @Autowired
    private DataServerConfig dataServerBootstrapConfig;
    @Resource(name="dataClientHandlers")
    private Collection<AbstractClientHandler> dataClientHandlers;

    public Response request(Request request) {
        Channel channel = this.connect(request.getRequestUrl());
        Client client = this.boltExchange.getClient("dataServer");
        LOGGER.info("DataNode Exchanger request={},url={},callbackHandler={}", new Object[]{request.getRequestBody(), request.getRequestUrl(), request.getCallBackHandler()});
        if (null != request.getCallBackHandler()) {
            client.sendCallback(channel, request.getRequestBody(), request.getCallBackHandler(), this.dataServerBootstrapConfig.getRpcTimeout());
            return () -> Response.ResultStatus.SUCCESSFUL;
        }
        Object result = client.sendSync(channel, request.getRequestBody(), this.dataServerBootstrapConfig.getRpcTimeout());
        return () -> result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Channel connect(URL url) {
        Channel channel;
        Client client = this.boltExchange.getClient("dataServer");
        if (client == null) {
            DataNodeExchanger dataNodeExchanger = this;
            synchronized (dataNodeExchanger) {
                client = this.boltExchange.getClient("dataServer");
                if (client == null) {
                    client = this.boltExchange.connect("dataServer", url, (Object[])this.dataClientHandlers.toArray(new ChannelHandler[this.dataClientHandlers.size()]));
                }
            }
        }
        if ((channel = client.getChannel(url)) == null) {
            DataNodeExchanger dataNodeExchanger = this;
            synchronized (dataNodeExchanger) {
                channel = client.getChannel(url);
                if (channel == null) {
                    channel = client.connect(url);
                }
            }
        }
        return channel;
    }

    public Client connectServer() {
        throw new UnsupportedOperationException();
    }
}

