/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.data.remoting.sessionserver.disconnect;

import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.server.data.bootstrap.DataServerConfig;
import com.alipay.sofa.registry.server.data.change.event.ClientChangeEvent;
import com.alipay.sofa.registry.server.data.change.event.DataChangeEventCenter;
import com.alipay.sofa.registry.server.data.executor.ExecutorFactory;
import com.alipay.sofa.registry.server.data.remoting.sessionserver.SessionServerConnectionFactory;
import com.alipay.sofa.registry.server.data.remoting.sessionserver.disconnect.ClientDisconnectEvent;
import com.alipay.sofa.registry.server.data.remoting.sessionserver.disconnect.DisconnectEvent;
import com.alipay.sofa.registry.server.data.remoting.sessionserver.disconnect.DisconnectTypeEnum;
import com.alipay.sofa.registry.server.data.remoting.sessionserver.disconnect.SessionServerDisconnectEvent;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Executor;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;

public class DisconnectEventHandler
implements InitializingBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(DisconnectEventHandler.class);
    private final DelayQueue<DisconnectEvent> EVENT_QUEUE = new DelayQueue();
    @Autowired
    private SessionServerConnectionFactory sessionServerConnectionFactory;
    @Autowired
    private DataChangeEventCenter dataChangeEventCenter;
    @Autowired
    private DataServerConfig dataServerConfig;

    public void receive(DisconnectEvent event) {
        if (event.getType() == DisconnectTypeEnum.SESSION_SERVER) {
            SessionServerDisconnectEvent sessionServerDisconnectEvent = (SessionServerDisconnectEvent)event;
            LOGGER.info("receive session off event: sessionServerHost={}, processId={}", (Object)sessionServerDisconnectEvent.getSessionServerHost(), (Object)sessionServerDisconnectEvent.getProcessId());
        }
        this.EVENT_QUEUE.add(event);
    }

    public void afterPropertiesSet() {
        LOGGER.info("begin start DisconnectEventHandler");
        Executor executor = ExecutorFactory.newSingleThreadExecutor(DisconnectEventHandler.class.getSimpleName());
        executor.execute(() -> {
            while (true) {
                try {
                    block3: while (true) {
                        DisconnectEvent event;
                        DisconnectEvent disconnectEvent;
                        if ((disconnectEvent = (DisconnectEvent)this.EVENT_QUEUE.take()).getType() == DisconnectTypeEnum.SESSION_SERVER) {
                            String sessionServerHost;
                            event = (SessionServerDisconnectEvent)disconnectEvent;
                            String processId = ((SessionServerDisconnectEvent)event).getProcessId();
                            if (this.sessionServerConnectionFactory.removeProcessIfMatch(processId, sessionServerHost = ((SessionServerDisconnectEvent)event).getSessionServerHost())) {
                                Set<String> clientHosts = this.sessionServerConnectionFactory.removeClients(processId);
                                LOGGER.info("session off is triggered: sessionServerHost={}, clientHost={}, processId={}", new Object[]{sessionServerHost, clientHosts, processId});
                                if (clientHosts == null || clientHosts.isEmpty()) continue;
                                Iterator<String> iterator = clientHosts.iterator();
                                while (true) {
                                    if (!iterator.hasNext()) continue block3;
                                    String host = iterator.next();
                                    this.unPub(host, event.getRegisterTimestamp());
                                }
                            }
                            LOGGER.info("session off is canceled: sessionServerHost={}, processId={}", (Object)sessionServerHost, (Object)processId);
                            continue;
                        }
                        event = (ClientDisconnectEvent)disconnectEvent;
                        this.unPub(((ClientDisconnectEvent)event).getHost(), event.getRegisterTimestamp());
                    }
                }
                catch (Throwable e) {
                    LOGGER.error("handle client disconnect event failed", e);
                    continue;
                }
                break;
            }
        });
        LOGGER.info("start DisconnectEventHandler success");
    }

    private void unPub(String host, long registerTimestamp) {
        this.dataChangeEventCenter.onChange(new ClientChangeEvent(host, this.dataServerConfig.getLocalDataCenter(), registerTimestamp));
    }
}

