/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.data.util;

import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class DelayItem<T>
implements Delayed {
    private static final AtomicLong SEQUENCER = new AtomicLong(0L);
    private final long sequenceNumber;
    private final T item;
    private final long time;

    public DelayItem(T submit, long timeout) {
        this.time = DelayItem.now() + timeout;
        this.item = submit;
        this.sequenceNumber = SEQUENCER.getAndIncrement();
    }

    static long now() {
        return System.currentTimeMillis();
    }

    @Override
    public long getDelay(TimeUnit unit) {
        return unit.convert(this.time - DelayItem.now(), TimeUnit.MILLISECONDS);
    }

    public T getItem() {
        return this.item;
    }

    @Override
    public int compareTo(Delayed other) {
        if (other == this) {
            return 0;
        }
        if (other instanceof DelayItem) {
            DelayItem x = (DelayItem)other;
            long diff = this.time - x.time;
            if (diff < 0L) {
                return -1;
            }
            if (diff > 0L) {
                return 1;
            }
            if (this.sequenceNumber < x.sequenceNumber) {
                return -1;
            }
            return 1;
        }
        long d = this.getDelay(TimeUnit.MILLISECONDS) - other.getDelay(TimeUnit.MILLISECONDS);
        return d == 0L ? 0 : (d < 0L ? -1 : 1);
    }
}

