/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.meta.bootstrap;

import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.net.NetUtil;
import com.alipay.sofa.registry.server.meta.bootstrap.NodeConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;

public abstract class AbstractNodeConfigBean
implements NodeConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractNodeConfigBean.class);
    protected Map<String, Collection<String>> metaNodeIP;
    private Map<String, String> dataCenterMetaIPCache = new HashMap<String, String>();

    @Override
    public Map<String, Collection<String>> getMetaNodeIP() {
        if (this.metaNodeIP == null || this.metaNodeIP.isEmpty()) {
            this.metaNodeIP = this.convertToIP(this.getMetaNode());
        }
        return this.metaNodeIP;
    }

    private Map<String, Collection<String>> convertToIP(Map<String, Collection<String>> input) {
        HashMap<String, Collection<String>> ret = new HashMap<String, Collection<String>>();
        try {
            if (input != null) {
                input.forEach((dataCenter, domains) -> {
                    if (domains != null) {
                        ArrayList ipList = new ArrayList();
                        domains.forEach(domain -> {
                            if (domain != null) {
                                String ip = NetUtil.getIPAddressFromDomain((String)domain);
                                if (ip == null) {
                                    LOGGER.error("Node config convert domain {} error!", domain);
                                    throw new RuntimeException("Node config convert domain {" + domain + "} error!");
                                }
                                ipList.add(ip);
                            }
                        });
                        ret.put((String)dataCenter, ipList);
                    }
                });
            }
        }
        catch (Exception e) {
            LOGGER.error("Node config convert domain error!", (Throwable)e);
            throw new RuntimeException("Node config convert domain error!", e);
        }
        return ret;
    }

    @Override
    public String getMetaDataCenter(String metaIpAddress) {
        if (metaIpAddress == null || metaIpAddress.isEmpty()) {
            LOGGER.error("IpAddress:" + metaIpAddress + " cannot be null!");
            return null;
        }
        String dataCenterRet = this.dataCenterMetaIPCache.get(metaIpAddress);
        if (dataCenterRet == null || dataCenterRet.isEmpty()) {
            Map<String, Collection<String>> metaList = this.getMetaNodeIP();
            AtomicReference ret = new AtomicReference();
            metaList.forEach((dataCenter, list) -> {
                if (list.contains(metaIpAddress)) {
                    ret.set(dataCenter);
                }
            });
            if (ret.get() == null) {
                LOGGER.error("node ipAddress:" + metaIpAddress + " cannot be found on config list!");
            }
            dataCenterRet = (String)ret.get();
        }
        return dataCenterRet;
    }

    @Override
    public Set<String> getDataCenterMetaServers(String dataCenterIn) {
        Collection<String> list;
        Map<String, Collection<String>> metaMap = this.getMetaNodeIP();
        HashSet<String> metaServerIpSet = new HashSet<String>();
        if (metaMap != null && metaMap.size() > 0 && (list = metaMap.get(dataCenterIn)) != null) {
            metaServerIpSet.addAll(list);
        }
        return metaServerIpSet;
    }
}

