/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.meta.bootstrap;

import com.alipay.sofa.registry.common.model.store.URL;
import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.net.NetUtil;
import com.alipay.sofa.registry.remoting.ChannelHandler;
import com.alipay.sofa.registry.remoting.Server;
import com.alipay.sofa.registry.remoting.exchange.Exchange;
import com.alipay.sofa.registry.server.meta.bootstrap.MetaServerConfig;
import com.alipay.sofa.registry.server.meta.executor.ExecutorManager;
import com.alipay.sofa.registry.server.meta.remoting.RaftExchanger;
import com.alipay.sofa.registry.server.meta.remoting.handler.AbstractServerHandler;
import com.alipay.sofa.registry.task.batcher.TaskDispatchers;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Resource;
import javax.ws.rs.Path;
import javax.ws.rs.ext.Provider;
import org.glassfish.jersey.server.ResourceConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

public class MetaServerBootstrap {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetaServerBootstrap.class);
    @Autowired
    private MetaServerConfig metaServerConfig;
    @Autowired
    private Exchange boltExchange;
    @Autowired
    private Exchange jerseyExchange;
    @Autowired
    private ExecutorManager executorManager;
    @Resource(name="sessionServerHandlers")
    private Collection<AbstractServerHandler> sessionServerHandlers;
    @Resource(name="dataServerHandlers")
    private Collection<AbstractServerHandler> dataServerHandlers;
    @Resource(name="metaServerHandlers")
    private Collection<AbstractServerHandler> metaServerHandlers;
    @Autowired
    private ResourceConfig jerseyResourceConfig;
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private RaftExchanger raftExchanger;
    private Server sessionServer;
    private Server dataServer;
    private Server metaServer;
    private Server httpServer;
    private AtomicBoolean sessionStart = new AtomicBoolean(false);
    private AtomicBoolean dataStart = new AtomicBoolean(false);
    private AtomicBoolean metaStart = new AtomicBoolean(false);
    private AtomicBoolean httpStart = new AtomicBoolean(false);

    public void doInitialized() {
        try {
            this.openSessionRegisterServer();
            this.openDataRegisterServer();
            this.openMetaRegisterServer();
            this.openHttpServer();
            this.initRaft();
            Runtime.getRuntime().addShutdownHook(new Thread(this::doStop));
        }
        catch (Throwable e) {
            LOGGER.error("Bootstrap Meta Server got error!", e);
            throw new RuntimeException("Bootstrap Meta Server got error!", e);
        }
    }

    public void destroy() {
        this.doStop();
    }

    private void doStop() {
        try {
            LOGGER.info("{} Shutting down Meta Server..", (Object)new Date().toString());
            this.executorManager.stopScheduler();
            TaskDispatchers.stopDefaultSingleTaskDispatcher();
            this.stopServer();
        }
        catch (Throwable e) {
            LOGGER.error("Shutting down Meta Server error!", e);
        }
        LOGGER.info("{} Meta server is now shutdown...", (Object)new Date().toString());
    }

    private void openSessionRegisterServer() {
        try {
            if (this.sessionStart.compareAndSet(false, true)) {
                this.sessionServer = this.boltExchange.open(new URL(NetUtil.getLocalAddress().getHostAddress(), this.metaServerConfig.getSessionServerPort()), (Object[])this.sessionServerHandlers.toArray(new ChannelHandler[this.sessionServerHandlers.size()]));
                LOGGER.info("Open session node register server port {} success!", (Object)this.metaServerConfig.getSessionServerPort());
            }
        }
        catch (Exception e) {
            this.sessionStart.set(false);
            LOGGER.error("Open session node register server port {} error!", (Object)this.metaServerConfig.getSessionServerPort(), (Object)e);
            throw new RuntimeException("Open session node register server error!", e);
        }
    }

    private void openDataRegisterServer() {
        try {
            if (this.dataStart.compareAndSet(false, true)) {
                this.dataServer = this.boltExchange.open(new URL(NetUtil.getLocalAddress().getHostAddress(), this.metaServerConfig.getDataServerPort()), (Object[])this.dataServerHandlers.toArray(new ChannelHandler[this.dataServerHandlers.size()]));
                LOGGER.info("Open data node register server port {} success!", (Object)this.metaServerConfig.getDataServerPort());
            }
        }
        catch (Exception e) {
            this.dataStart.set(false);
            LOGGER.error("Open data node register server port {} error!", (Object)this.metaServerConfig.getDataServerPort(), (Object)e);
            throw new RuntimeException("Open data node register server error!", e);
        }
    }

    private void openMetaRegisterServer() {
        try {
            if (this.metaStart.compareAndSet(false, true)) {
                this.metaServer = this.boltExchange.open(new URL(NetUtil.getLocalAddress().getHostAddress(), this.metaServerConfig.getMetaServerPort()), (Object[])this.metaServerHandlers.toArray(new ChannelHandler[this.metaServerHandlers.size()]));
                LOGGER.info("Open meta server port {} success!", (Object)this.metaServerConfig.getMetaServerPort());
            }
        }
        catch (Exception e) {
            this.metaStart.set(false);
            LOGGER.error("Open meta server port {} error!", (Object)this.metaServerConfig.getMetaServerPort(), (Object)e);
            throw new RuntimeException("Open meta server error!", e);
        }
    }

    private void openHttpServer() {
        try {
            if (this.httpStart.compareAndSet(false, true)) {
                this.bindResourceConfig();
                this.httpServer = this.jerseyExchange.open(new URL(NetUtil.getLocalAddress().getHostAddress(), this.metaServerConfig.getHttpServerPort()), (Object[])new ResourceConfig[]{this.jerseyResourceConfig});
                LOGGER.info("Open http server port {} success!", (Object)this.metaServerConfig.getHttpServerPort());
            }
        }
        catch (Exception e) {
            this.httpStart.set(false);
            LOGGER.error("Open http server port {} error!", (Object)this.metaServerConfig.getHttpServerPort(), (Object)e);
            throw new RuntimeException("Open http server error!", e);
        }
    }

    private void bindResourceConfig() {
        this.registerInstances(Path.class);
        this.registerInstances(Provider.class);
    }

    private void registerInstances(Class<? extends Annotation> annotationType) {
        Map beans = this.applicationContext.getBeansWithAnnotation(annotationType);
        if (beans != null && beans.size() > 0) {
            beans.forEach((beanName, bean) -> this.jerseyResourceConfig.registerInstances(new Object[]{bean}));
        }
    }

    private void initRaft() {
        this.raftExchanger.startRaftServer(this.executorManager);
        LOGGER.info("Raft server port {} start success!group {}", (Object)this.metaServerConfig.getRaftServerPort(), (Object)this.metaServerConfig.getRaftGroup());
        this.raftExchanger.startRaftClient();
        LOGGER.info("Raft client connect success!");
        this.raftExchanger.startCliService();
        LOGGER.info("Raft start CliService success!");
    }

    private void stopServer() {
        if (this.sessionServer != null && this.sessionServer.isOpen()) {
            this.sessionServer.close();
        }
        if (this.dataServer != null && this.dataServer.isOpen()) {
            this.dataServer.close();
        }
        if (this.metaServer != null && this.metaServer.isOpen()) {
            this.metaServer.close();
        }
        if (this.httpServer != null && this.httpServer.isOpen()) {
            this.httpServer.close();
        }
        if (this.raftExchanger != null) {
            this.raftExchanger.shutdown();
        }
    }

    public AtomicBoolean getSessionStart() {
        return this.sessionStart;
    }

    public AtomicBoolean getDataStart() {
        return this.dataStart;
    }

    public AtomicBoolean getMetaStart() {
        return this.metaStart;
    }

    public AtomicBoolean getHttpStart() {
        return this.httpStart;
    }
}

