/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.meta.repository.service;

import com.alipay.sofa.registry.common.model.metaserver.MetaNode;
import com.alipay.sofa.registry.jraft.processor.AbstractSnapshotProcess;
import com.alipay.sofa.registry.jraft.processor.SnapshotProcess;
import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.server.meta.bootstrap.NodeConfig;
import com.alipay.sofa.registry.server.meta.repository.NodeRepository;
import com.alipay.sofa.registry.server.meta.repository.RepositoryService;
import com.alipay.sofa.registry.server.meta.store.RenewDecorate;
import com.alipay.sofa.registry.store.api.annotation.RaftService;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.springframework.beans.factory.annotation.Autowired;

@RaftService(uniqueId="metaServer")
public class MetaRepositoryService
extends AbstractSnapshotProcess
implements RepositoryService<String, RenewDecorate<MetaNode>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetaRepositoryService.class);
    @Autowired
    private NodeConfig nodeConfig;
    private final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final Lock read = this.readWriteLock.readLock();
    private final Lock write = this.readWriteLock.writeLock();
    private Map<String, NodeRepository> registry = new ConcurrentHashMap<String, NodeRepository>();
    private Set<String> snapShotFileNames = new HashSet<String>();

    public MetaRepositoryService() {
    }

    public MetaRepositoryService(Map<String, NodeRepository> registry) {
        this.registry = registry;
    }

    public SnapshotProcess copy() {
        return new MetaRepositoryService(new ConcurrentHashMap<String, NodeRepository>(this.registry));
    }

    @Override
    public RenewDecorate<MetaNode> put(String ipAddress, RenewDecorate<MetaNode> metaNode) {
        this.write.lock();
        try {
            NodeRepository nodeRepository;
            String dataCenter = metaNode.getRenewal().getDataCenter();
            NodeRepository metaNodeRepository = this.registry.get(dataCenter);
            if (metaNodeRepository == null && (metaNodeRepository = this.registry.put(dataCenter, nodeRepository = new NodeRepository(dataCenter, new ConcurrentHashMap(), System.currentTimeMillis()))) == null) {
                metaNodeRepository = nodeRepository;
            }
            metaNodeRepository.setVersion(System.currentTimeMillis());
            Map metaNodes = metaNodeRepository.getNodeMap();
            RenewDecorate oldRenewDecorate = metaNodes.get(ipAddress);
            if (oldRenewDecorate != null && oldRenewDecorate.getRenewal() != null) {
                LOGGER.info("Meta node with ipAddress:" + ipAddress + " has already existed!");
            }
            metaNodes.put(ipAddress, metaNode);
        }
        catch (Exception e) {
            LOGGER.error("Meta node add error!", (Throwable)e);
            throw new RuntimeException("Meta node add error!", e);
        }
        finally {
            this.write.unlock();
        }
        return metaNode;
    }

    @Override
    public RenewDecorate<MetaNode> remove(Object key) {
        this.write.lock();
        try {
            Map metaNodes;
            String ipAddress = (String)key;
            String dataCenter = this.nodeConfig.getLocalDataCenter();
            NodeRepository metaNodeRepository = this.registry.get(dataCenter);
            if (metaNodeRepository != null && (metaNodes = metaNodeRepository.getNodeMap()) != null) {
                RenewDecorate<MetaNode> oldRenewDecorate = metaNodes.remove(ipAddress);
                if (oldRenewDecorate == null) {
                    LOGGER.warn("Meta node with ipAddress:" + ipAddress + " has not exist!");
                    RenewDecorate<MetaNode> renewDecorate = null;
                    return renewDecorate;
                }
                metaNodeRepository.setVersion(System.currentTimeMillis());
                RenewDecorate<MetaNode> renewDecorate = oldRenewDecorate;
                return renewDecorate;
            }
            RenewDecorate<MetaNode> renewDecorate = null;
            return renewDecorate;
        }
        catch (Exception e) {
            LOGGER.error("Meta node remove error!", (Throwable)e);
            throw new RuntimeException("Meta node remove error!", e);
        }
        finally {
            this.write.unlock();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public RenewDecorate<MetaNode> replace(String ipAddress, RenewDecorate<MetaNode> metaNode) {
        this.write.lock();
        try {
            String dataCenter = metaNode.getRenewal().getDataCenter();
            NodeRepository metaNodeRepository = this.registry.get(dataCenter);
            if (metaNodeRepository != null) {
                Map dataNodes = metaNodeRepository.getNodeMap();
                if (dataNodes == null) {
                    LOGGER.error("Meta node in dataCenter {} has not existed!", (Object)dataCenter);
                    throw new RuntimeException(String.format("Meta node in dataCenter %s has not existed!", dataCenter));
                }
                RenewDecorate<MetaNode> oldRenewDecorate = dataNodes.get(ipAddress);
                if (oldRenewDecorate != null && oldRenewDecorate.getRenewal() != null) {
                    oldRenewDecorate.setRenewal(metaNode.getRenewal());
                    oldRenewDecorate.reNew();
                    metaNodeRepository.setVersion(System.currentTimeMillis());
                    RenewDecorate<MetaNode> renewDecorate = metaNode;
                    return renewDecorate;
                }
                LOGGER.error("Meta node with ipAddress {} has not existed!", (Object)ipAddress);
                throw new RuntimeException(String.format("Meta node with ipAddress %s has not existed!", ipAddress));
            }
            LOGGER.error("Meta node in dataCenter: {} has not existed!", (Object)dataCenter);
            throw new RuntimeException(String.format("Meta node in dataCenter: %s has not existed!", dataCenter));
        }
        catch (Exception e) {
            LOGGER.error("Data node replace error!", (Throwable)e);
            throw new RuntimeException("Data node replace error!", e);
        }
        finally {
            this.write.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, RenewDecorate<MetaNode>> replaceAll(String dataCenter, Map<String, RenewDecorate<MetaNode>> map, Long version) {
        this.write.lock();
        try {
            NodeRepository metaNodeRepository = this.registry.get(dataCenter);
            if (metaNodeRepository != null) {
                Map<String, RenewDecorate<MetaNode>> oldMap = metaNodeRepository.getNodeMap();
                if (oldMap == null) {
                    LOGGER.warn("Meta node in dataCenter: {} has not existed!", (Object)dataCenter);
                }
                metaNodeRepository.setNodeMap(map);
                metaNodeRepository.setVersion(version);
                Map<String, RenewDecorate<MetaNode>> map2 = oldMap;
                return map2;
            }
            this.registry.put(dataCenter, new NodeRepository(dataCenter, map, version));
            Map<String, RenewDecorate<MetaNode>> map3 = map;
            return map3;
        }
        finally {
            this.write.unlock();
        }
    }

    @Override
    public RenewDecorate<MetaNode> get(Object key) {
        this.read.lock();
        try {
            String ipAddress = (String)key;
            String dataCenter = this.nodeConfig.getLocalDataCenter();
            NodeRepository dataNodeRepository = this.registry.get(dataCenter);
            if (dataNodeRepository != null) {
                Map metaNodes = dataNodeRepository.getNodeMap();
                if (metaNodes == null) {
                    LOGGER.error("Meta node in dataCenter: {} has not existed!", (Object)dataCenter);
                    throw new RuntimeException(String.format("Meta node in dataCenter: %s has not existed!", dataCenter));
                }
                RenewDecorate<MetaNode> oldRenewDecorate = metaNodes.get(ipAddress);
                if (oldRenewDecorate != null && oldRenewDecorate.getRenewal() != null) {
                    RenewDecorate<MetaNode> renewDecorate = oldRenewDecorate;
                    return renewDecorate;
                }
                LOGGER.warn("Meta node with ipAddress {} has not existed!It not be registered!", (Object)ipAddress);
                RenewDecorate<MetaNode> renewDecorate = null;
                return renewDecorate;
            }
            try {
                LOGGER.error("Meta node in dataCenter: {} has not existed!", (Object)dataCenter);
                throw new RuntimeException(String.format("Meta node in dataCenter: %s has not existed!", dataCenter));
            }
            catch (Exception e) {
                LOGGER.error("Get meta node error!", (Throwable)e);
                throw new RuntimeException("Get meta node error!", e);
            }
        }
        finally {
            this.read.unlock();
        }
    }

    @Override
    public Map<String, RenewDecorate<MetaNode>> getAllData() {
        this.read.lock();
        try {
            ConcurrentHashMap<String, RenewDecorate<MetaNode>> nodes = new ConcurrentHashMap<String, RenewDecorate<MetaNode>>();
            this.registry.forEach((dataCenter, metaNodeRepository) -> nodes.putAll(metaNodeRepository.getNodeMap()));
            ConcurrentHashMap<String, RenewDecorate<MetaNode>> concurrentHashMap = nodes;
            return concurrentHashMap;
        }
        finally {
            this.read.unlock();
        }
    }

    @Override
    public Map<String, Map<String, RenewDecorate<MetaNode>>> getAllDataMap() {
        ConcurrentHashMap<String, Map<String, RenewDecorate<MetaNode>>> nodes = new ConcurrentHashMap<String, Map<String, RenewDecorate<MetaNode>>>();
        this.read.lock();
        try {
            this.registry.forEach((dataCenter, metaNodeRepository) -> nodes.put((String)dataCenter, metaNodeRepository.getNodeMap()));
            ConcurrentHashMap<String, Map<String, RenewDecorate<MetaNode>>> concurrentHashMap = nodes;
            return concurrentHashMap;
        }
        finally {
            this.read.unlock();
        }
    }

    @Override
    public Map<String, NodeRepository> getNodeRepositories() {
        return this.registry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkVersion(String dataCenter, Long version) {
        this.read.lock();
        try {
            NodeRepository metaNodeRepository = this.registry.get(dataCenter);
            if (metaNodeRepository != null) {
                Long oldValue = metaNodeRepository.getVersion();
                boolean bl = oldValue == null || version > oldValue;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.read.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long getVersion(String dataCenter) {
        this.read.lock();
        try {
            NodeRepository dataNodeRepository = this.registry.get(dataCenter);
            if (dataNodeRepository != null) {
                Long l = dataNodeRepository.getVersion();
                return l;
            }
            Long l = null;
            return l;
        }
        finally {
            this.read.unlock();
        }
    }

    public boolean save(String path) {
        return this.save(path, this.registry);
    }

    public synchronized boolean load(String path) {
        try {
            Map map = (Map)this.load(path, this.registry.getClass());
            this.registry.clear();
            this.registry.putAll(map);
            return true;
        }
        catch (IOException e) {
            LOGGER.error("Load registry meta error!", (Throwable)e);
            return false;
        }
    }

    public Set<String> getSnapshotFileNames() {
        if (!this.snapShotFileNames.isEmpty()) {
            return this.snapShotFileNames;
        }
        this.snapShotFileNames.add(this.getClass().getSimpleName());
        return this.snapShotFileNames;
    }
}

