/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.meta.task;

import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.server.meta.task.MetaServerTask;
import com.alipay.sofa.registry.task.Retryable;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class AbstractMetaServerTask
implements MetaServerTask,
Retryable {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractMetaServerTask.class, (String)"[Task]");
    protected volatile String taskId;
    private AtomicInteger execCount = new AtomicInteger(1);

    public synchronized String getTaskId() {
        if (this.taskId == null) {
            this.taskId = UUID.randomUUID().toString();
        }
        return this.taskId;
    }

    public long getExpiryTime() {
        return -1L;
    }

    protected boolean checkRetryTimes(int configTimes) {
        if (configTimes > 0) {
            if (this.execCount.incrementAndGet() > configTimes) {
                LOGGER.info("retry times more than {},info:{}", (Object)configTimes, (Object)this);
                return false;
            }
            return true;
        }
        return false;
    }
}

