/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.meta.task;

import com.alipay.sofa.registry.common.model.Node;
import com.alipay.sofa.registry.common.model.metaserver.DataNode;
import com.alipay.sofa.registry.common.model.metaserver.NodeChangeResult;
import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.server.meta.bootstrap.MetaServerConfig;
import com.alipay.sofa.registry.server.meta.bootstrap.ServiceFactory;
import com.alipay.sofa.registry.server.meta.node.DataNodeService;
import com.alipay.sofa.registry.server.meta.node.SessionNodeService;
import com.alipay.sofa.registry.server.meta.task.AbstractMetaServerTask;
import com.alipay.sofa.registry.task.listener.TaskEvent;
import java.util.Map;

public class DataNodeChangePushTask
extends AbstractMetaServerTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataNodeChangePushTask.class, (String)"[Task]");
    private final SessionNodeService sessionNodeService;
    private final DataNodeService dataNodeService;
    private final MetaServerConfig metaServerConfig;
    private final Node.NodeType nodeType;
    private NodeChangeResult nodeChangeResult;
    private Boolean confirm;
    private String confirmNodeIp;
    private Map<String, DataNode> targetNodes;

    public DataNodeChangePushTask(Node.NodeType nodeType, MetaServerConfig metaServerConfig) {
        this.metaServerConfig = metaServerConfig;
        this.nodeType = nodeType;
        this.sessionNodeService = (SessionNodeService)ServiceFactory.getNodeService(Node.NodeType.SESSION);
        this.dataNodeService = (DataNodeService)ServiceFactory.getNodeService(Node.NodeType.DATA);
    }

    public void setTaskEvent(TaskEvent taskEvent) {
        this.confirm = (Boolean)taskEvent.getAttribute("NEED_CONFIRM");
        this.targetNodes = (Map)taskEvent.getAttribute("PUSH_TARGET_DATA_NODE");
        this.confirmNodeIp = (String)taskEvent.getAttribute("PUSH_TARGET_CONFIRM_NODE");
        Object obj = taskEvent.getEventObj();
        if (!(obj instanceof NodeChangeResult)) {
            throw new IllegalArgumentException("Input task event object error!");
        }
        this.nodeChangeResult = (NodeChangeResult)obj;
    }

    public void execute() {
        switch (this.nodeType) {
            case SESSION: {
                this.sessionNodeService.pushDataNodes(this.nodeChangeResult);
                LOGGER.info("push change to Session Nodes!");
                break;
            }
            case DATA: {
                this.dataNodeService.pushDataNodes(this.nodeChangeResult, this.targetNodes, this.confirm, this.confirmNodeIp);
                LOGGER.info("push change to Data Nodes!");
                break;
            }
        }
    }

    public String toString() {
        return "DATA_NODE_CHANGE_PUSH_TASK {taskId='" + this.taskId + '\'' + ", nodeType='" + this.nodeType + '\'' + ", nodeChangeRequest=" + this.nodeChangeResult + '}';
    }

    public boolean checkRetryTimes() {
        return this.checkRetryTimes(this.metaServerConfig.getDataNodeChangePushTaskRetryTimes());
    }
}

