/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.session.node.processor;

import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.server.session.scheduler.task.SessionTask;
import com.alipay.sofa.registry.task.Retryable;
import com.alipay.sofa.registry.task.batcher.TaskProcessor;
import java.util.List;

public class ConsoleSyncSingleTaskProcessor
implements TaskProcessor<SessionTask> {
    private static final Logger CONSOLE_LOGGER = LoggerFactory.getLogger((String)"SESSION-CONSOLE", (String)"[Sync]");

    public TaskProcessor.ProcessingResult process(SessionTask task) {
        try {
            CONSOLE_LOGGER.info("execute {}", (Object)task);
            task.execute();
            CONSOLE_LOGGER.info("end {}", (Object)task);
            return TaskProcessor.ProcessingResult.Success;
        }
        catch (Throwable throwable) {
            Retryable retryAbleTask;
            CONSOLE_LOGGER.error("Sync to console SingleTask Process error! Task:" + task, throwable);
            if (task instanceof Retryable && (retryAbleTask = (Retryable)task).checkRetryTimes()) {
                return TaskProcessor.ProcessingResult.TransientError;
            }
            return TaskProcessor.ProcessingResult.PermanentError;
        }
    }

    public TaskProcessor.ProcessingResult process(List<SessionTask> tasks) {
        return null;
    }
}

