/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.session.remoting.handler;

import com.alipay.sofa.registry.common.model.Node;
import com.alipay.sofa.registry.common.model.sessionserver.CancelAddressRequest;
import com.alipay.sofa.registry.core.model.Result;
import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.remoting.Channel;
import com.alipay.sofa.registry.remoting.ChannelHandler;
import com.alipay.sofa.registry.server.session.registry.Registry;
import com.alipay.sofa.registry.server.session.remoting.handler.AbstractServerHandler;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public class CancelAddressRequestHandler
extends AbstractServerHandler<CancelAddressRequest> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CancelAddressRequestHandler.class);
    private static final Logger EXCHANGE_LOGGER = LoggerFactory.getLogger((String)"SESSION-EXCHANGE", (String)"[CancelAddressRequestHandler]");
    @Autowired
    private Registry sessionRegistry;

    public ChannelHandler.HandlerType getType() {
        return ChannelHandler.HandlerType.PROCESSER;
    }

    @Override
    public Class interest() {
        return CancelAddressRequest.class;
    }

    @Override
    protected Node.NodeType getConnectNodeType() {
        return Node.NodeType.CLIENT;
    }

    @Override
    public Object reply(Channel channel, CancelAddressRequest cancelProcessRequest) {
        Result result = new Result();
        try {
            EXCHANGE_LOGGER.info("request={}", (Object)cancelProcessRequest);
            List connectIds = cancelProcessRequest.getConnectIds();
            if (connectIds == null || connectIds.isEmpty()) {
                LOGGER.error("Request connectIds cannot be null or empty!");
                result.setMessage("Request connectIds cannot be null or empty!");
                result.setSuccess(false);
                return result;
            }
            this.sessionRegistry.cancel(connectIds);
        }
        catch (Exception e) {
            LOGGER.error("Cancel Address Request error!", (Throwable)e);
            throw new RuntimeException("Cancel Address Request error!", e);
        }
        result.setSuccess(true);
        return result;
    }
}

