/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.session.strategy.impl;

import com.alipay.sofa.registry.common.model.store.Publisher;
import com.alipay.sofa.registry.common.model.store.Subscriber;
import com.alipay.sofa.registry.common.model.store.Watcher;
import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.server.session.bootstrap.SessionServerConfig;
import com.alipay.sofa.registry.server.session.cache.CacheService;
import com.alipay.sofa.registry.server.session.cache.DatumKey;
import com.alipay.sofa.registry.server.session.cache.Key;
import com.alipay.sofa.registry.server.session.store.Interests;
import com.alipay.sofa.registry.server.session.strategy.SessionRegistryStrategy;
import com.alipay.sofa.registry.task.listener.TaskEvent;
import com.alipay.sofa.registry.task.listener.TaskListenerManager;
import java.util.HashSet;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class DefaultSessionRegistryStrategy
implements SessionRegistryStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultSessionRegistryStrategy.class);
    private static final Logger CONSOLE_LOGGER = LoggerFactory.getLogger((String)"SESSION-CONSOLE", (String)"[Task]");
    private static final Logger taskLogger = LoggerFactory.getLogger(DefaultSessionRegistryStrategy.class, (String)"[Task]");
    @Autowired
    private Interests sessionInterests;
    @Autowired
    private TaskListenerManager taskListenerManager;
    @Autowired
    private SessionServerConfig sessionServerConfig;
    @Autowired
    private CacheService sessionCacheService;

    @Override
    public void doFetchChangDataProcess(Map<String, Map<String, Long>> dataInfoIdVersions) {
        HashSet changeDataInfoIds = new HashSet();
        dataInfoIdVersions.forEach((dataCenter, dataInfoIdMap) -> {
            if (dataInfoIdMap != null) {
                dataInfoIdMap.forEach((dataInfoID, version) -> {
                    if (this.checkInterestVersions((String)dataCenter, (String)dataInfoID, (Long)version)) {
                        this.sessionCacheService.invalidate(new Key(Key.KeyType.OBJ, DatumKey.class.getName(), new DatumKey((String)dataInfoID, (String)dataCenter)));
                        changeDataInfoIds.add(dataInfoID);
                    }
                });
            }
        });
        changeDataInfoIds.forEach(this::fireDataChangeCloudTask);
    }

    private boolean checkInterestVersions(String dataCenter, String dataInfoId, Long version) {
        boolean result = this.sessionInterests.checkInterestVersions(dataCenter, dataInfoId, version);
        if (result) {
            LOGGER.info("Request dataCenter {} dataInfo {} fetch version {} be interested,Higher than current version!Will fire data change Task", new Object[]{dataCenter, dataInfoId, version});
        }
        return result;
    }

    private void fireDataChangeCloudTask(String dataInfoId) {
        TaskEvent taskEvent = new TaskEvent((Object)dataInfoId, TaskEvent.TaskType.DATA_CHANGE_FETCH_CLOUD_TASK);
        taskLogger.info("send " + taskEvent.getTaskType() + " taskEvent:{}", (Object)taskEvent);
        this.taskListenerManager.sendTaskEvent(taskEvent);
    }

    @Override
    public void afterPublisherRegister(Publisher publisher) {
        TaskEvent syncPublisherTask = new TaskEvent((Object)publisher, TaskEvent.TaskType.SYNC_PUBLISHER_TASK);
        CONSOLE_LOGGER.info("send " + syncPublisherTask.getTaskType() + " taskEvent:{}", (Object)publisher);
        this.taskListenerManager.sendTaskEvent(syncPublisherTask);
    }

    @Override
    public void afterSubscriberRegister(Subscriber subscriber) {
        if (!this.sessionServerConfig.isStopPushSwitch()) {
            TaskEvent taskEvent = new TaskEvent((Object)subscriber, TaskEvent.TaskType.SUBSCRIBER_REGISTER_FETCH_TASK);
            taskLogger.info("send " + taskEvent.getTaskType() + " taskEvent:{}", (Object)taskEvent);
            this.taskListenerManager.sendTaskEvent(taskEvent);
        }
    }

    @Override
    public void afterWatcherRegister(Watcher watcher) {
        this.fireWatcherRegisterFetchTask(watcher);
    }

    @Override
    public void afterPublisherUnRegister(Publisher publisher) {
    }

    @Override
    public void afterSubscriberUnRegister(Subscriber subscriber) {
    }

    @Override
    public void afterWatcherUnRegister(Watcher watcher) {
    }

    private void fireWatcherRegisterFetchTask(Watcher watcher) {
        TaskEvent taskEvent = new TaskEvent((Object)watcher, TaskEvent.TaskType.WATCHER_REGISTER_FETCH_TASK);
        taskLogger.info("send " + taskEvent.getTaskType() + " taskEvent:{}", (Object)taskEvent);
        this.taskListenerManager.sendTaskEvent(taskEvent);
    }
}

