/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.jraft.service;

import com.alipay.sofa.registry.jraft.processor.AbstractSnapshotProcess;
import com.alipay.sofa.registry.jraft.processor.SnapshotProcess;
import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.store.api.DBResponse;
import com.alipay.sofa.registry.store.api.DBService;
import com.alipay.sofa.registry.store.api.annotation.RaftService;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

@RaftService
public class PersistenceDataDBService
extends AbstractSnapshotProcess
implements DBService {
    private static final Logger LOGGER = LoggerFactory.getLogger(PersistenceDataDBService.class);
    private ConcurrentHashMap<String, Object> serviceMap = new ConcurrentHashMap();
    private Set<String> snapShotFileNames = new HashSet<String>();

    public PersistenceDataDBService() {
    }

    public PersistenceDataDBService(ConcurrentHashMap<String, Object> serviceMap) {
        this.serviceMap = serviceMap;
    }

    @Override
    public SnapshotProcess copy() {
        return new PersistenceDataDBService(new ConcurrentHashMap<String, Object>(this.serviceMap));
    }

    public void openDB(String dbName, Class entityClass) {
    }

    public boolean put(String key, Object value) {
        if (key == null || value == null) {
            LOGGER.error("key {} or value {} can't be null", (Object)key, value);
            return false;
        }
        Object ret = this.serviceMap.put(key, value);
        if (ret != null) {
            LOGGER.warn("value {} with key {} will be override", ret, (Object)key);
        }
        return true;
    }

    public DBResponse get(String key) {
        if (key == null) {
            LOGGER.error("key can't be null");
            throw new IllegalArgumentException("query key can't be null");
        }
        Object ret = this.serviceMap.get(key);
        return ret != null ? DBResponse.ok((Object)ret).build() : DBResponse.notfound().build();
    }

    public boolean update(String key, Object value) {
        if (key == null || value == null) {
            LOGGER.error("key {} or value {} can't be null", (Object)key, value);
            return false;
        }
        Object ret = this.serviceMap.put(key, value);
        if (ret != null) {
            LOGGER.warn("value {} with key {} will be override", ret, (Object)key);
        }
        return true;
    }

    public boolean remove(String key) {
        if (key == null) {
            LOGGER.error("key can't be null");
            return false;
        }
        Object obj = this.serviceMap.remove(key);
        if (obj == null) {
            LOGGER.warn("remove key {} can't be found!", (Object)key);
            return false;
        }
        return true;
    }

    @Override
    public boolean save(String path) {
        return this.save(path, this.serviceMap);
    }

    @Override
    public boolean load(String path) {
        try {
            ConcurrentHashMap map = (ConcurrentHashMap)this.load(path, this.serviceMap.getClass());
            this.serviceMap.clear();
            this.serviceMap.putAll(map);
            return true;
        }
        catch (IOException e) {
            LOGGER.error("Load serviceMap data error!", (Throwable)e);
            return false;
        }
    }

    @Override
    public Set<String> getSnapshotFileNames() {
        if (!this.snapShotFileNames.isEmpty()) {
            return this.snapShotFileNames;
        }
        this.snapShotFileNames.add(this.getClass().getSimpleName());
        return this.snapShotFileNames;
    }
}

