/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.boot.common;

import com.alipay.sofa.rpc.boot.log.SofaBootRpcLoggerFactory;
import com.alipay.sofa.rpc.common.utils.StringUtils;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;

public class RpcThreadPoolMonitor {
    private static final long DEFAULT_SLEEP_TIME = 30000L;
    private final Logger logger;
    private long sleepTimeMS;
    private ThreadPoolExecutor threadPoolExecutor;
    private AtomicInteger startTimes = new AtomicInteger(0);
    private volatile boolean active = true;
    private Thread monitor;
    private String poolName = "";

    public RpcThreadPoolMonitor(String loggerName) {
        this(null, loggerName, 30000L);
    }

    public RpcThreadPoolMonitor(ThreadPoolExecutor threadPoolExecutor, String loggerName) {
        this(threadPoolExecutor, loggerName, 30000L);
    }

    public RpcThreadPoolMonitor(ThreadPoolExecutor threadPoolExecutor, String loggerName, long sleepTimeMS) {
        this.threadPoolExecutor = threadPoolExecutor;
        this.logger = SofaBootRpcLoggerFactory.getLogger(loggerName);
        this.sleepTimeMS = sleepTimeMS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void start() {
        RpcThreadPoolMonitor rpcThreadPoolMonitor = this;
        synchronized (rpcThreadPoolMonitor) {
            if (this.threadPoolExecutor == null) throw new RuntimeException("the rpc thread pool is null");
            if (this.startTimes.intValue() != 0) throw new RuntimeException("rpc started event has been consumed");
            if (this.startTimes.incrementAndGet() != 1) throw new RuntimeException("rpc started event has been consumed");
            StringBuilder sb = new StringBuilder();
            sb.append("coreSize:" + this.threadPoolExecutor.getCorePoolSize() + ",");
            sb.append("maxPoolSize:" + this.threadPoolExecutor.getMaximumPoolSize() + ",");
            sb.append("keepAliveTime:" + this.threadPoolExecutor.getKeepAliveTime(TimeUnit.MILLISECONDS) + "\n");
            if (this.logger.isInfoEnabled()) {
                this.logger.info(sb.toString());
            }
            this.monitor = new Thread(){

                @Override
                public void run() {
                    while (RpcThreadPoolMonitor.this.active) {
                        try {
                            if (RpcThreadPoolMonitor.this.logger.isInfoEnabled()) {
                                StringBuilder sb = new StringBuilder();
                                int blockQueueSize = RpcThreadPoolMonitor.this.threadPoolExecutor.getQueue().size();
                                int activeSize = RpcThreadPoolMonitor.this.threadPoolExecutor.getActiveCount();
                                int poolSize = RpcThreadPoolMonitor.this.threadPoolExecutor.getPoolSize();
                                sb.append("blockQueue:" + blockQueueSize + ", ");
                                sb.append("active:" + activeSize + ", ");
                                sb.append("idle:" + (poolSize - activeSize) + ", ");
                                sb.append("poolSize:" + poolSize);
                                if (StringUtils.isNotBlank((CharSequence)RpcThreadPoolMonitor.this.poolName)) {
                                    sb.append(", poolName: " + RpcThreadPoolMonitor.this.poolName);
                                }
                                RpcThreadPoolMonitor.this.logger.info(sb.toString());
                            }
                        }
                        catch (Throwable throwable) {
                            RpcThreadPoolMonitor.this.logger.error("Thread pool monitor error", throwable);
                        }
                        try {
                            1.sleep(RpcThreadPoolMonitor.this.sleepTimeMS);
                        }
                        catch (InterruptedException e) {
                            RpcThreadPoolMonitor.this.logger.error("Error happened when the thread pool monitor is sleeping");
                        }
                    }
                }
            };
            this.monitor.setDaemon(true);
            this.monitor.setName("RPC-RES-MONITOR");
            this.monitor.start();
            return;
        }
    }

    public void setThreadPoolExecutor(ThreadPoolExecutor threadPoolExecutor) {
        this.threadPoolExecutor = threadPoolExecutor;
    }

    public void setPoolName(String poolName) {
        this.poolName = poolName;
    }

    public String getPoolName() {
        return this.poolName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        RpcThreadPoolMonitor rpcThreadPoolMonitor = this;
        synchronized (rpcThreadPoolMonitor) {
            this.active = false;
            if (this.monitor != null) {
                this.monitor.interrupt();
                this.monitor = null;
            }
            this.threadPoolExecutor = null;
            this.startTimes.set(0);
        }
    }

    public Thread getMonitor() {
        return this.monitor;
    }
}

