/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.common.xmap;

import com.alipay.sofa.common.xmap.AttributeValueMapVisitor;
import com.alipay.sofa.common.xmap.Context;
import com.alipay.sofa.common.xmap.DOMHelper;
import com.alipay.sofa.common.xmap.ElementMapVisitor;
import com.alipay.sofa.common.xmap.ElementValueMapVisitor;
import com.alipay.sofa.common.xmap.Path;
import com.alipay.sofa.common.xmap.XAnnotatedList;
import com.alipay.sofa.common.xmap.XGetter;
import com.alipay.sofa.common.xmap.XMap;
import com.alipay.sofa.common.xmap.XSetter;
import com.alipay.sofa.common.xmap.annotation.XNodeMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XAnnotatedMap
extends XAnnotatedList {
    protected static final ElementMapVisitor elementMapVisitor = new ElementMapVisitor();
    protected static final ElementValueMapVisitor elementVisitor = new ElementValueMapVisitor();
    protected static final AttributeValueMapVisitor attributeVisitor = new AttributeValueMapVisitor();
    protected Path key;

    public XAnnotatedMap(XMap xmap, XSetter setter, XGetter getter, XNodeMap anno) {
        super(xmap, setter, getter);
        if (anno != null) {
            this.path = new Path(anno.value());
            this.trim = anno.trim();
            this.key = new Path(anno.key());
            this.type = anno.type();
            this.cdata = anno.cdata();
            this.componentType = anno.componentType();
            this.valueFactory = xmap.getValueFactory(this.componentType);
            this.xao = xmap.register(this.componentType);
        }
    }

    @Override
    protected Object getValue(Context ctx, Element base) throws IllegalAccessException, InstantiationException {
        Map values = (Map)this.type.newInstance();
        if (this.xao != null) {
            DOMHelper.visitMapNodes(ctx, this, base, this.path, elementMapVisitor, values);
        } else if (this.path.attribute != null) {
            DOMHelper.visitMapNodes(ctx, this, base, this.path, attributeVisitor, values);
        } else {
            DOMHelper.visitMapNodes(ctx, this, base, this.path, elementVisitor, values);
        }
        return values;
    }

    @Override
    public void decode(Object instance, Node base, Document document, List<String> filters) throws Exception {
        if (!this.isFilter(filters)) {
            return;
        }
        Map values = (Map)this.getter.getValue(instance);
        Node node = base;
        int len = this.path.segments.length - 1;
        for (int i = 0; i < len; ++i) {
            Node n = DOMHelper.getElementNode(node, this.path.segments[i]);
            if (n == null) {
                Element element = document.createElement(this.path.segments[i]);
                node = node.appendChild(element);
                continue;
            }
            node = n;
        }
        String name = this.path.segments[len];
        Node lastParentNode = node;
        Set entrys = values.entrySet();
        for (Map.Entry entry : entrys) {
            String value;
            Element element = document.createElement(name);
            node = lastParentNode.appendChild(element);
            Object keyObj = entry.getKey();
            String keyValue = keyObj == null ? "" : keyObj.toString();
            Object object = entry.getValue();
            Attr attrKey = document.createAttribute(this.key.attribute);
            attrKey.setNodeValue(keyValue);
            ((Element)node).setAttributeNode(attrKey);
            if (this.xao != null) {
                this.xao.decode(object, node, document, filters);
                continue;
            }
            String string = value = object == null ? "" : object.toString();
            if (this.path.attribute != null && this.path.attribute.length() > 0) {
                Attr attrValue = document.createAttribute(this.path.attribute);
                attrValue.setNodeValue(value);
                ((Element)node).setAttributeNode(attrValue);
                continue;
            }
            if (this.cdata) {
                CDATASection cdataSection = document.createCDATASection(value);
                node.appendChild(cdataSection);
                continue;
            }
            node.setTextContent(value);
        }
    }
}

