/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.runtime.service.binding;

import com.alipay.sofa.runtime.api.binding.BindingType;
import com.alipay.sofa.runtime.api.component.ComponentName;
import com.alipay.sofa.runtime.integration.invoke.DynamicJvmServiceProxyFinder;
import com.alipay.sofa.runtime.service.binding.JvmBinding;
import com.alipay.sofa.runtime.service.component.ServiceComponent;
import com.alipay.sofa.runtime.spi.binding.BindingAdapter;
import com.alipay.sofa.runtime.spi.binding.Contract;
import com.alipay.sofa.runtime.spi.component.ComponentInfo;
import com.alipay.sofa.runtime.spi.component.SofaRuntimeContext;
import com.alipay.sofa.runtime.spi.log.SofaLogger;
import com.alipay.sofa.runtime.spi.service.ServiceProxy;
import com.alipay.sofa.runtime.spi.util.ComponentNameFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.framework.ProxyFactory;

public class JvmBindingAdapter
implements BindingAdapter<JvmBinding> {
    @Override
    public void preOutBinding(Object contract, JvmBinding binding, Object target, SofaRuntimeContext sofaRuntimeContext) {
    }

    @Override
    public Object outBinding(Object contract, JvmBinding binding, Object target, SofaRuntimeContext sofaRuntimeContext) {
        return null;
    }

    @Override
    public void preUnoutBinding(Object contract, JvmBinding binding, Object target, SofaRuntimeContext sofaRuntimeContext) {
    }

    @Override
    public void postUnoutBinding(Object contract, JvmBinding binding, Object target, SofaRuntimeContext sofaRuntimeContext) {
    }

    @Override
    public BindingType getBindingType() {
        return JvmBinding.JVM_BINDING_TYPE;
    }

    @Override
    public Class<JvmBinding> getBindingClass() {
        return JvmBinding.class;
    }

    @Override
    public Object inBinding(Object contract, JvmBinding binding, SofaRuntimeContext sofaRuntimeContext) {
        return this.createServiceProxy((Contract)contract, binding, sofaRuntimeContext);
    }

    @Override
    public void unInBinding(Object contract, JvmBinding binding, SofaRuntimeContext sofaRuntimeContext) {
        binding.setDestroyed(true);
        if (binding.hasBackupProxy()) {
            binding.setBackupProxy(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object createServiceProxy(Contract contract, JvmBinding binding, SofaRuntimeContext sofaRuntimeContext) {
        ClassLoader newClassLoader;
        ClassLoader appClassLoader = sofaRuntimeContext.getAppClassLoader();
        Class<?> javaClass = contract.getInterfaceType();
        try {
            Class<?> appLoadedClass = appClassLoader.loadClass(javaClass.getName());
            newClassLoader = appLoadedClass == javaClass ? appClassLoader : javaClass.getClassLoader();
        }
        catch (ClassNotFoundException e) {
            newClassLoader = javaClass.getClassLoader();
        }
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(newClassLoader);
            JvmServiceInvoker handler = new JvmServiceInvoker(contract, binding, sofaRuntimeContext);
            ProxyFactory factory = new ProxyFactory();
            if (javaClass.isInterface()) {
                factory.addInterface(javaClass);
            } else {
                factory.setTargetClass(javaClass);
                factory.setProxyTargetClass(true);
            }
            factory.addAdvice((Advice)handler);
            Object object = factory.getProxy(newClassLoader);
            return object;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    static class JvmServiceInvoker
    extends ServiceProxy {
        private Contract contract;
        private JvmBinding binding;
        private Object target;
        private SofaRuntimeContext sofaRuntimeContext;

        public JvmServiceInvoker(Contract contract, JvmBinding binding, SofaRuntimeContext sofaRuntimeContext) {
            super(sofaRuntimeContext.getAppClassLoader());
            this.binding = binding;
            this.sofaRuntimeContext = sofaRuntimeContext;
            this.contract = contract;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object doInvoke(MethodInvocation invocation) throws Throwable {
            Object retVal;
            ServiceProxy serviceProxy;
            if (this.binding.isDestroyed()) {
                throw new IllegalStateException("Can not call destroyed reference! JVM Reference[" + this.getInterfaceName() + "#" + this.getUniqueId() + "] has already been destroyed.");
            }
            SofaLogger.debug(">> Start in JVM service invoke, the service interface is  - {0}", this.getInterfaceName());
            Object targetObj = this.getTarget();
            if (targetObj == null && (serviceProxy = DynamicJvmServiceProxyFinder.getDynamicJvmServiceProxyFinder().findServiceProxy(this.sofaRuntimeContext.getAppClassLoader(), this.contract)) != null) {
                Object object;
                try {
                    object = serviceProxy.invoke(invocation);
                }
                catch (Throwable throwable) {
                    SofaLogger.debug("<< Finish Cross App JVM service invoke, the service is  - {0}]", this.getInterfaceName() + "#" + this.getUniqueId());
                    throw throwable;
                }
                SofaLogger.debug("<< Finish Cross App JVM service invoke, the service is  - {0}]", this.getInterfaceName() + "#" + this.getUniqueId());
                return object;
            }
            if (targetObj == null || targetObj instanceof Proxy && this.binding.hasBackupProxy()) {
                targetObj = this.binding.getBackupProxy();
                SofaLogger.debug("<<{0}.{1} backup proxy invoke.", this.getInterfaceName().getName(), invocation.getMethod().getName());
            }
            if (targetObj == null) {
                throw new IllegalStateException("JVM Reference[" + this.getInterfaceName() + "#" + this.getUniqueId() + "] can not find the corresponding JVM service. Please check if there is a SOFA deployment publish the corresponding JVM service. If this exception occurred when the application starts up, please add Require-Module to SOFA deployment's MANIFEST.MF to indicate the startup dependency of SOFA modules.");
            }
            ClassLoader tcl = Thread.currentThread().getContextClassLoader();
            try {
                this.pushThreadContextClassLoader(this.sofaRuntimeContext.getAppClassLoader());
                retVal = invocation.getMethod().invoke(targetObj, invocation.getArguments());
            }
            catch (InvocationTargetException ex) {
                try {
                    throw ex.getTargetException();
                }
                catch (Throwable throwable) {
                    SofaLogger.debug("<< Finish JVM service invoke, the service implementation is  - {0}]", this.target == null ? "null" : this.target.getClass().getName());
                    this.popThreadContextClassLoader(tcl);
                    throw throwable;
                }
            }
            SofaLogger.debug("<< Finish JVM service invoke, the service implementation is  - {0}]", this.target == null ? "null" : this.target.getClass().getName());
            this.popThreadContextClassLoader(tcl);
            return retVal;
        }

        @Override
        protected void doCatch(MethodInvocation invocation, Throwable e, long startTime) {
            if (SofaLogger.isDebugEnabled()) {
                SofaLogger.debug(this.getCommonInvocationLog("Exception", invocation, startTime), new Object[0]);
            }
        }

        @Override
        protected void doFinally(MethodInvocation invocation, long startTime) {
            if (SofaLogger.isDebugEnabled()) {
                SofaLogger.debug(this.getCommonInvocationLog("Finally", invocation, startTime), new Object[0]);
            }
        }

        protected Object getTarget() {
            if (this.target == null) {
                ComponentName componentName = ComponentNameFactory.createComponentName(ServiceComponent.SERVICE_COMPONENT_TYPE, this.getInterfaceName(), this.contract.getUniqueId());
                ComponentInfo componentInfo = this.sofaRuntimeContext.getComponentManager().getComponentInfo(componentName);
                if (componentInfo != null) {
                    this.target = componentInfo.getImplementation().getTarget();
                }
            }
            return this.target;
        }

        protected Class<?> getInterfaceName() {
            return this.contract.getInterfaceType();
        }

        protected String getUniqueId() {
            return this.contract.getUniqueId();
        }
    }
}

