/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.runtime.spring.bean;

import com.alipay.sofa.runtime.annotation.PlaceHolderAnnotationInvocationHandler;
import com.alipay.sofa.runtime.annotation.PlaceHolderBinder;
import com.alipay.sofa.runtime.api.annotation.SofaReference;
import com.alipay.sofa.runtime.spring.bean.SofaBeanNameGenerator;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.core.env.Environment;

public class SofaParameterNameDiscoverer
implements ParameterNameDiscoverer {
    private final PlaceHolderBinder binder = new DefaultPlaceHolderBinder();
    private LocalVariableTableParameterNameDiscoverer localVariableTableParameterNameDiscoverer = new LocalVariableTableParameterNameDiscoverer();
    private Environment environment;

    public SofaParameterNameDiscoverer(Environment environment) {
        this.environment = environment;
    }

    public String[] getParameterNames(Method method) {
        String[] parameterNames = this.localVariableTableParameterNameDiscoverer.getParameterNames(method);
        Class<?>[] parameterTypes = method.getParameterTypes();
        Annotation[][] annotations = method.getParameterAnnotations();
        return this.transformParameterNames(parameterNames, parameterTypes, annotations);
    }

    public String[] getParameterNames(Constructor<?> ctor) {
        String[] parameterNames = this.localVariableTableParameterNameDiscoverer.getParameterNames(ctor);
        Class<?>[] parameterTypes = ctor.getParameterTypes();
        Annotation[][] annotations = ctor.getParameterAnnotations();
        return this.transformParameterNames(parameterNames, parameterTypes, annotations);
    }

    protected String[] transformParameterNames(String[] parameterNames, Class<?>[] parameterType, Annotation[][] annotations) {
        for (int i = 0; i < annotations.length; ++i) {
            for (Annotation annotation : annotations[i]) {
                if (!(annotation instanceof SofaReference)) continue;
                PlaceHolderAnnotationInvocationHandler.AnnotationWrapperBuilder wrapperBuilder = PlaceHolderAnnotationInvocationHandler.AnnotationWrapperBuilder.wrap(annotation).withBinder(this.binder);
                SofaReference delegate = (SofaReference)wrapperBuilder.build();
                Class<?> interfaceType = delegate.interfaceType();
                if (interfaceType.equals(Void.TYPE)) {
                    interfaceType = parameterType[i];
                }
                String uniqueId = delegate.uniqueId();
                parameterNames[i] = SofaBeanNameGenerator.generateSofaReferenceBeanName(interfaceType, uniqueId);
            }
        }
        return parameterNames;
    }

    class DefaultPlaceHolderBinder
    implements PlaceHolderBinder {
        DefaultPlaceHolderBinder() {
        }

        @Override
        public String bind(String text) {
            return SofaParameterNameDiscoverer.this.environment.resolvePlaceholders(text);
        }
    }
}

