/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.runtime.proxy;

import com.alipay.sofa.runtime.proxy.SofaProxyFactoryBean;
import org.springframework.aop.framework.ProxyFactoryBean;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.core.PriorityOrdered;

public class ProxyBeanFactoryPostProcessor
implements BeanFactoryPostProcessor,
PriorityOrdered {
    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        boolean updateProxyBean = false;
        for (String beanName : beanFactory.getBeanNamesForType(ProxyFactoryBean.class, true, false)) {
            String transformedBeanName = BeanFactoryUtils.transformedBeanName((String)beanName);
            if (!beanFactory.containsBeanDefinition(transformedBeanName)) continue;
            BeanDefinition beanDefinition = beanFactory.getBeanDefinition(transformedBeanName);
            if (!ProxyFactoryBean.class.getName().equals(beanDefinition.getBeanClassName())) continue;
            beanDefinition.setBeanClassName(SofaProxyFactoryBean.class.getName());
            Object proxyInterfaces = beanDefinition.getPropertyValues().get("proxyInterfaces");
            if (proxyInterfaces == null) {
                proxyInterfaces = beanDefinition.getPropertyValues().get("interfaces");
            }
            beanDefinition.getConstructorArgumentValues().addIndexedArgumentValue(0, proxyInterfaces);
            beanDefinition.getConstructorArgumentValues().addIndexedArgumentValue(1, beanDefinition.getPropertyValues().get("targetName"));
            beanDefinition.getConstructorArgumentValues().addIndexedArgumentValue(2, beanDefinition.getPropertyValues().get("targetClass"));
            beanDefinition.getConstructorArgumentValues().addIndexedArgumentValue(3, (Object)beanFactory);
            updateProxyBean = true;
        }
        if (updateProxyBean) {
            beanFactory.clearMetadataCache();
        }
    }

    public int getOrder() {
        return 0;
    }
}

