/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.runtime.service.binding;

import com.alipay.sofa.boot.error.ErrorCode;
import com.alipay.sofa.runtime.SofaRuntimeProperties;
import com.alipay.sofa.runtime.api.binding.BindingType;
import com.alipay.sofa.runtime.api.component.ComponentName;
import com.alipay.sofa.runtime.filter.JvmFilterContext;
import com.alipay.sofa.runtime.filter.JvmFilterHolder;
import com.alipay.sofa.runtime.invoke.DynamicJvmServiceProxyFinder;
import com.alipay.sofa.runtime.log.SofaLogger;
import com.alipay.sofa.runtime.service.binding.JvmBinding;
import com.alipay.sofa.runtime.service.component.ServiceComponent;
import com.alipay.sofa.runtime.spi.binding.BindingAdapter;
import com.alipay.sofa.runtime.spi.binding.Contract;
import com.alipay.sofa.runtime.spi.component.ComponentInfo;
import com.alipay.sofa.runtime.spi.component.SofaRuntimeContext;
import com.alipay.sofa.runtime.spi.service.ServiceProxy;
import com.alipay.sofa.runtime.spi.util.ComponentNameFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.framework.ProxyFactory;

public class JvmBindingAdapter
implements BindingAdapter<JvmBinding> {
    @Override
    public void preOutBinding(Object contract, JvmBinding binding, Object target, SofaRuntimeContext sofaRuntimeContext) {
    }

    @Override
    public Object outBinding(Object contract, JvmBinding binding, Object target, SofaRuntimeContext sofaRuntimeContext) {
        return null;
    }

    @Override
    public void preUnoutBinding(Object contract, JvmBinding binding, Object target, SofaRuntimeContext sofaRuntimeContext) {
    }

    @Override
    public void postUnoutBinding(Object contract, JvmBinding binding, Object target, SofaRuntimeContext sofaRuntimeContext) {
    }

    @Override
    public BindingType getBindingType() {
        return JvmBinding.JVM_BINDING_TYPE;
    }

    @Override
    public Class<JvmBinding> getBindingClass() {
        return JvmBinding.class;
    }

    @Override
    public Object inBinding(Object contract, JvmBinding binding, SofaRuntimeContext sofaRuntimeContext) {
        return this.createServiceProxy((Contract)contract, binding, sofaRuntimeContext);
    }

    @Override
    public void unInBinding(Object contract, JvmBinding binding, SofaRuntimeContext sofaRuntimeContext) {
        binding.setDestroyed(true);
        if (binding.hasBackupProxy()) {
            binding.setBackupProxy(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object createServiceProxy(Contract contract, JvmBinding binding, SofaRuntimeContext sofaRuntimeContext) {
        ClassLoader newClassLoader;
        ClassLoader appClassLoader = sofaRuntimeContext.getAppClassLoader();
        Class<?> javaClass = contract.getInterfaceType();
        try {
            Class<?> appLoadedClass = appClassLoader.loadClass(javaClass.getName());
            newClassLoader = appLoadedClass == javaClass ? appClassLoader : javaClass.getClassLoader();
        }
        catch (ClassNotFoundException e) {
            newClassLoader = javaClass.getClassLoader();
        }
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(newClassLoader);
            JvmServiceInvoker handler = new JvmServiceInvoker(contract, binding, sofaRuntimeContext);
            ProxyFactory factory = new ProxyFactory();
            if (javaClass.isInterface()) {
                factory.addInterface(javaClass);
            } else {
                factory.setTargetClass(javaClass);
                factory.setProxyTargetClass(true);
            }
            factory.addAdvice((Advice)handler);
            Object object = factory.getProxy(newClassLoader);
            return object;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    static class JvmServiceInvoker
    extends ServiceProxy {
        private Contract contract;
        private JvmBinding binding;
        private Object target;
        private SofaRuntimeContext sofaRuntimeContext;

        public JvmServiceInvoker(Contract contract, JvmBinding binding, SofaRuntimeContext sofaRuntimeContext) {
            super(sofaRuntimeContext.getAppClassLoader());
            this.binding = binding;
            this.sofaRuntimeContext = sofaRuntimeContext;
            this.contract = contract;
        }

        @Override
        public Object invoke(MethodInvocation invocation) throws Throwable {
            Object rtn;
            if (!SofaRuntimeProperties.isJvmFilterEnable()) {
                return super.invoke(invocation);
            }
            ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
            JvmFilterContext context = new JvmFilterContext(invocation);
            if (this.getTarget() == null) {
                ServiceComponent serviceComponent = DynamicJvmServiceProxyFinder.getDynamicJvmServiceProxyFinder().findServiceComponent(this.sofaRuntimeContext.getAppClassLoader(), this.contract);
                if (serviceComponent == null) {
                    return super.invoke(invocation);
                }
                context.setSofaRuntimeContext(serviceComponent.getContext());
            } else {
                context.setSofaRuntimeContext(this.sofaRuntimeContext);
            }
            long startTime = System.currentTimeMillis();
            try {
                Thread.currentThread().setContextClassLoader(this.serviceClassLoader);
                if (JvmFilterHolder.beforeInvoking(context)) {
                    rtn = this.doInvoke(invocation);
                    context.setInvokeResult(rtn);
                }
            }
            catch (Throwable e) {
                context.setException(e);
                this.doCatch(invocation, e, startTime);
                throw e;
            }
            finally {
                JvmFilterHolder.afterInvoking(context);
                rtn = context.getInvokeResult();
                this.doFinally(invocation, startTime);
                Thread.currentThread().setContextClassLoader(oldClassLoader);
            }
            return rtn;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object doInvoke(MethodInvocation invocation) throws Throwable {
            Object retVal;
            ServiceProxy serviceProxy;
            if (this.binding.isDestroyed()) {
                throw new IllegalStateException("Can not call destroyed reference! JVM Reference[" + this.getInterfaceName() + "#" + this.getUniqueId() + "] has already been destroyed.");
            }
            SofaLogger.debug(">> Start in JVM service invoke, the service interface is  - {}", this.getInterfaceName());
            Object targetObj = this.getTarget();
            if (targetObj == null && (serviceProxy = DynamicJvmServiceProxyFinder.getDynamicJvmServiceProxyFinder().findServiceProxy(this.sofaRuntimeContext.getAppClassLoader(), this.contract)) != null) {
                try {
                    Object object = serviceProxy.invoke(invocation);
                    return object;
                }
                finally {
                    SofaLogger.debug("<< Finish Cross App JVM service invoke, the service is  - {}]", (Object)(this.getInterfaceName() + "#" + this.getUniqueId()));
                }
            }
            if (targetObj == null || targetObj instanceof Proxy && this.binding.hasBackupProxy()) {
                targetObj = this.binding.getBackupProxy();
                SofaLogger.debug("<<{}.{} backup proxy invoke.", (Object)this.getInterfaceName().getName(), (Object)invocation.getMethod().getName());
            }
            if (targetObj == null) {
                throw new IllegalStateException(ErrorCode.convert((String)"01-00400", (Object[])new Object[]{this.getInterfaceName(), this.getUniqueId()}));
            }
            ClassLoader tcl = Thread.currentThread().getContextClassLoader();
            try {
                this.pushThreadContextClassLoader(this.sofaRuntimeContext.getAppClassLoader());
                retVal = invocation.getMethod().invoke(targetObj, invocation.getArguments());
                SofaLogger.debug("<< Finish JVM service invoke, the service implementation is  - {}]", (Object)(this.target == null ? "null" : this.target.getClass().getName()));
            }
            catch (InvocationTargetException ex) {
                try {
                    throw ex.getTargetException();
                }
                catch (Throwable throwable) {
                    SofaLogger.debug("<< Finish JVM service invoke, the service implementation is  - {}]", (Object)(this.target == null ? "null" : this.target.getClass().getName()));
                    this.popThreadContextClassLoader(tcl);
                    throw throwable;
                }
            }
            this.popThreadContextClassLoader(tcl);
            return retVal;
        }

        @Override
        protected void doCatch(MethodInvocation invocation, Throwable e, long startTime) {
            if (SofaLogger.isDebugEnabled()) {
                SofaLogger.debug(this.getCommonInvocationLog("Exception", invocation, startTime));
            }
        }

        @Override
        protected void doFinally(MethodInvocation invocation, long startTime) {
            if (SofaLogger.isDebugEnabled()) {
                SofaLogger.debug(this.getCommonInvocationLog("Finally", invocation, startTime));
            }
        }

        protected Object getTarget() {
            if (this.target == null) {
                ComponentName componentName = ComponentNameFactory.createComponentName(ServiceComponent.SERVICE_COMPONENT_TYPE, this.getInterfaceName(), this.contract.getUniqueId());
                ComponentInfo componentInfo = this.sofaRuntimeContext.getComponentManager().getComponentInfo(componentName);
                if (componentInfo != null) {
                    this.target = componentInfo.getImplementation().getTarget();
                }
            }
            return this.target;
        }

        protected Class<?> getInterfaceName() {
            return this.contract.getInterfaceType();
        }

        protected String getUniqueId() {
            return this.contract.getUniqueId();
        }
    }
}

