/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.runtime.service.component;

import com.alipay.sofa.runtime.api.binding.BindingType;
import com.alipay.sofa.runtime.model.InterfaceMode;
import com.alipay.sofa.runtime.spi.binding.Binding;
import com.alipay.sofa.runtime.spi.binding.Contract;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class AbstractContract
implements Contract {
    protected Set<Binding> bindings = new HashSet<Binding>(2);
    protected String uniqueId = "";
    protected Class<?> interfaceType;
    protected InterfaceMode interfaceMode = InterfaceMode.spring;
    protected Map<String, String> property = new HashMap<String, String>();

    protected AbstractContract(String uniqueId, Class<?> interfaceType) {
        this.uniqueId = uniqueId == null ? "" : uniqueId;
        this.interfaceType = interfaceType;
    }

    protected AbstractContract(String uniqueId, Class<?> interfaceType, InterfaceMode interfaceMode) {
        this(uniqueId, interfaceType);
        this.interfaceMode = interfaceMode;
    }

    protected AbstractContract(String uniqueId, Class<?> interfaceType, InterfaceMode interfaceMode, Map<String, String> property) {
        this(uniqueId, interfaceType, interfaceMode);
        this.property = property;
    }

    @Override
    public <T extends Binding> void addBinding(T binding) {
        this.bindings.add(binding);
    }

    @Override
    public <T extends Binding> void addBinding(Set<T> bindings) {
        this.bindings.addAll(bindings);
    }

    @Override
    public Binding getBinding(BindingType bindingType) {
        for (Binding binding : this.bindings) {
            if (binding == null || binding.getBindingType() != bindingType) continue;
            return binding;
        }
        return null;
    }

    public Set<Binding> getBindings() {
        return this.bindings;
    }

    @Override
    public boolean hasBinding() {
        return this.bindings.size() > 0;
    }

    @Override
    public String getUniqueId() {
        return this.uniqueId;
    }

    @Override
    public InterfaceMode getInterfaceMode() {
        return this.interfaceMode;
    }

    @Override
    public Class<?> getInterfaceType() {
        return this.interfaceType;
    }

    @Override
    public String getProperty(String key) {
        if (this.property == null) {
            return null;
        }
        return this.property.get(key);
    }

    @Override
    public Map<String, String> getProperty() {
        return this.property;
    }
}

