/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.runtime.service.impl;

import com.alipay.sofa.runtime.api.binding.BindingType;
import com.alipay.sofa.runtime.spi.service.BindingConverter;
import com.alipay.sofa.runtime.spi.service.BindingConverterFactory;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;

public class BindingConverterFactoryImpl
implements BindingConverterFactory {
    private Map<BindingType, BindingConverter> bindingTypeBindingConverterMap = new HashMap<BindingType, BindingConverter>();
    private Map<String, BindingConverter> tagBindingConverterMap = new HashMap<String, BindingConverter>();

    @Override
    public BindingConverter getBindingConverter(BindingType bindingType) {
        return this.bindingTypeBindingConverterMap.get(bindingType);
    }

    @Override
    public BindingConverter getBindingConverterByTagName(String tagName) {
        return this.tagBindingConverterMap.get(tagName);
    }

    @Override
    public void addBindingConverters(Set<BindingConverter> bindingConverters) {
        if (bindingConverters == null || bindingConverters.size() == 0) {
            return;
        }
        ArrayList<BindingConverter> sortedBindingConverter = new ArrayList<BindingConverter>(bindingConverters);
        sortedBindingConverter.sort((Comparator<BindingConverter>)AnnotationAwareOrderComparator.INSTANCE);
        for (BindingConverter bindingConverter : sortedBindingConverter) {
            this.bindingTypeBindingConverterMap.putIfAbsent(bindingConverter.supportBindingType(), bindingConverter);
            this.tagBindingConverterMap.putIfAbsent(bindingConverter.supportTagName(), bindingConverter);
        }
    }
}

