/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.runtime.spring.factory;

import com.alipay.sofa.boot.error.ErrorCode;
import com.alipay.sofa.runtime.api.ServiceRuntimeException;
import com.alipay.sofa.runtime.spi.binding.Binding;
import com.alipay.sofa.runtime.spi.binding.BindingAdapterFactory;
import com.alipay.sofa.runtime.spi.component.SofaRuntimeContext;
import com.alipay.sofa.runtime.spi.service.BindingConverter;
import com.alipay.sofa.runtime.spi.service.BindingConverterContext;
import com.alipay.sofa.runtime.spi.service.BindingConverterFactory;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.TypedStringValue;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public abstract class AbstractContractFactoryBean
implements InitializingBean,
FactoryBean,
ApplicationContextAware {
    protected String beanId;
    protected String uniqueId;
    protected String interfaceType;
    protected Class<?> interfaceClass;
    protected SofaRuntimeContext sofaRuntimeContext;
    protected List<TypedStringValue> elements;
    protected ApplicationContext applicationContext;
    protected List<Binding> bindings = new ArrayList<Binding>(2);
    protected String documentEncoding;
    protected String repeatReferLimit;
    protected BindingConverterFactory bindingConverterFactory;
    protected BindingAdapterFactory bindingAdapterFactory;
    protected boolean apiType;

    public void afterPropertiesSet() throws Exception {
        ArrayList<Element> tempElements = new ArrayList<Element>();
        if (this.elements != null) {
            for (TypedStringValue element : this.elements) {
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setNamespaceAware(true);
                InputSource inputSource = new InputSource(new ByteArrayInputStream(element.getValue().getBytes()));
                inputSource.setEncoding(this.documentEncoding);
                Element node = documentBuilderFactory.newDocumentBuilder().parse(inputSource).getDocumentElement();
                tempElements.add(node);
            }
        }
        if (!this.apiType) {
            this.bindings = this.parseBindings(tempElements, this.applicationContext, this.isInBinding());
        }
        this.doAfterPropertiesSet();
    }

    protected List<Binding> parseBindings(List<Element> parseElements, ApplicationContext appContext, boolean isInBinding) {
        ArrayList<Binding> result = new ArrayList<Binding>();
        if (parseElements != null) {
            for (Element element : parseElements) {
                String tagName = element.getLocalName();
                BindingConverter bindingConverter = this.bindingConverterFactory.getBindingConverterByTagName(tagName);
                if (bindingConverter == null) {
                    this.dealWithbindingConverterNotExist(tagName);
                    continue;
                }
                BindingConverterContext bindingConverterContext = new BindingConverterContext();
                bindingConverterContext.setInBinding(isInBinding);
                bindingConverterContext.setApplicationContext(appContext);
                bindingConverterContext.setAppName(this.sofaRuntimeContext.getAppName());
                bindingConverterContext.setAppClassLoader(this.sofaRuntimeContext.getAppClassLoader());
                bindingConverterContext.setRepeatReferLimit(this.repeatReferLimit);
                bindingConverterContext.setBeanId(this.beanId);
                this.setProperties(bindingConverterContext);
                Object binding = bindingConverter.convert(element, bindingConverterContext);
                result.add((Binding)binding);
            }
        }
        return result;
    }

    protected void dealWithbindingConverterNotExist(String tagName) {
        throw new ServiceRuntimeException(ErrorCode.convert((String)"01-00200", (Object[])new Object[]{tagName}));
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public Class<?> getInterfaceClass() {
        if (this.interfaceClass == null) {
            try {
                this.interfaceClass = this.getClass().getClassLoader().loadClass(this.interfaceType);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            catch (NullPointerException e) {
                return null;
            }
        }
        return this.interfaceClass;
    }

    public void setInterfaceClass(Class interfaceType) {
        this.interfaceClass = interfaceType;
    }

    public List<Binding> getBindings() {
        return this.bindings;
    }

    public void setBindings(List<Binding> bindings) {
        this.bindings = bindings;
    }

    public void setUniqueId(String uniqueId) {
        this.uniqueId = uniqueId;
    }

    public void setInterfaceType(String interfaceType) {
        this.interfaceType = interfaceType;
    }

    public String getInterfaceType() {
        return this.interfaceType;
    }

    public void setElements(List<TypedStringValue> elements) {
        this.elements = elements;
    }

    public void setDocumentEncoding(String documentEncoding) {
        this.documentEncoding = documentEncoding;
    }

    public void setRepeatReferLimit(String repeatReferLimit) {
        this.repeatReferLimit = repeatReferLimit;
    }

    public String getBeanId() {
        return this.beanId;
    }

    public void setBeanId(String beanId) {
        this.beanId = beanId;
    }

    public boolean isSingleton() {
        return true;
    }

    public boolean isApiType() {
        return this.apiType;
    }

    public void setApiType(boolean apiType) {
        this.apiType = apiType;
    }

    public void setSofaRuntimeContext(SofaRuntimeContext sofaRuntimeContext) {
        this.sofaRuntimeContext = sofaRuntimeContext;
    }

    public void setBindingConverterFactory(BindingConverterFactory bindingConverterFactory) {
        this.bindingConverterFactory = bindingConverterFactory;
    }

    public void setBindingAdapterFactory(BindingAdapterFactory bindingAdapterFactory) {
        this.bindingAdapterFactory = bindingAdapterFactory;
    }

    protected abstract boolean isInBinding();

    protected abstract void doAfterPropertiesSet() throws Exception;

    protected abstract void setProperties(BindingConverterContext var1);
}

