/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.boot.autoconfigure.isle;

import com.alipay.sofa.isle.ApplicationRuntimeModel;
import com.alipay.sofa.isle.profile.DefaultSofaModuleProfileChecker;
import com.alipay.sofa.isle.profile.SofaModuleProfileChecker;
import com.alipay.sofa.isle.spring.SofaModuleBeanFactoryPostProcessor;
import com.alipay.sofa.isle.spring.SofaModuleContextLifecycle;
import com.alipay.sofa.isle.spring.config.SofaModuleProperties;
import com.alipay.sofa.isle.spring.share.SofaModulePostProcessorShareManager;
import com.alipay.sofa.isle.stage.DefaultPipelineContext;
import com.alipay.sofa.isle.stage.ModelCreatingStage;
import com.alipay.sofa.isle.stage.ModuleLogOutputStage;
import com.alipay.sofa.isle.stage.PipelineContext;
import com.alipay.sofa.isle.stage.PipelineStage;
import com.alipay.sofa.isle.stage.SpringContextInstallStage;
import java.util.List;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.AbstractApplicationContext;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={SofaModuleProperties.class})
@ConditionalOnClass(value={ApplicationRuntimeModel.class})
@ConditionalOnProperty(value={"com.alipay.sofa.boot.enable-isle"}, matchIfMissing=true)
public class SofaModuleAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public static SofaModuleBeanFactoryPostProcessor sofaModuleBeanFactoryPostProcessor(SofaModulePostProcessorShareManager shareManager) {
        return new SofaModuleBeanFactoryPostProcessor(shareManager);
    }

    @Bean
    @ConditionalOnMissingBean
    public SofaModuleContextLifecycle sofaModuleContextLifecycle(PipelineContext pipelineContext) {
        return new SofaModuleContextLifecycle(pipelineContext);
    }

    @Bean
    @ConditionalOnMissingBean
    public ModelCreatingStage modelCreatingStage(ApplicationContext applicationContext, SofaModuleProfileChecker sofaModuleProfileChecker) {
        return new ModelCreatingStage((AbstractApplicationContext)applicationContext, sofaModuleProfileChecker);
    }

    @Bean
    @ConditionalOnMissingBean
    public SpringContextInstallStage springContextInstallStage(ApplicationContext applicationContext, SofaModuleProperties sofaModuleProperties) {
        return new SpringContextInstallStage((AbstractApplicationContext)applicationContext, sofaModuleProperties);
    }

    @Bean
    @ConditionalOnMissingBean
    public ModuleLogOutputStage moduleLogOutputStage(ApplicationContext applicationContext) {
        return new ModuleLogOutputStage((AbstractApplicationContext)applicationContext);
    }

    @Bean
    @ConditionalOnMissingBean
    public PipelineContext pipelineContext(List<PipelineStage> stageList) {
        return new DefaultPipelineContext(stageList);
    }

    @Bean
    @ConditionalOnMissingBean
    public SofaModuleProfileChecker sofaModuleProfileChecker(SofaModuleProperties sofaModuleProperties) {
        return new DefaultSofaModuleProfileChecker(sofaModuleProperties);
    }

    @Bean
    @ConditionalOnMissingBean
    public SofaModulePostProcessorShareManager sofaModulePostProcessorShareManager(ApplicationContext applicationContext) {
        return new SofaModulePostProcessorShareManager((AbstractApplicationContext)applicationContext);
    }
}

