/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.client.http;

import com.alipay.sofa.rpc.common.json.JSON;
import com.alipay.sofa.rpc.log.Logger;
import com.alipay.sofa.rpc.log.LoggerFactory;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.util.EntityUtils;

public class RpcHttpClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(RpcHttpClient.class);
    private volatile CloseableHttpClient closeableHttpClient;
    private static RpcHttpClient INSTANCE = new RpcHttpClient();

    private RpcHttpClient() {
        this.shutdownHttpClientHook();
    }

    public static RpcHttpClient getInstance() {
        return INSTANCE;
    }

    public <T> T doGet(String url, Class<T> tClass) throws Throwable {
        long start = System.currentTimeMillis();
        CloseableHttpClient httpClient = this.getCloseableHttpClient();
        CloseableHttpResponse response = null;
        try {
            HttpGet httpGet = new HttpGet(url);
            RequestConfig requestConfig = this.parseRequestConfig();
            httpGet.setConfig(requestConfig);
            response = httpClient.execute((HttpUriRequest)httpGet);
            HttpEntity entity = response.getEntity();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("http client get success. url: {}. latency: {}ms.", url, System.currentTimeMillis() - start);
            }
            T t = JSON.parseObject(EntityUtils.toString((HttpEntity)entity), tClass);
            return t;
        }
        catch (Throwable throwable) {
            LOGGER.error("http client get error. url: " + url + ". latency: " + (System.currentTimeMillis() - start) + "ms.", throwable);
            throw throwable;
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException e) {
                    LOGGER.error("http client get close response error.", e);
                }
            }
        }
    }

    public <T> T doPost(String url, String jsonBody, Class<T> tClass) throws Throwable {
        long start = System.currentTimeMillis();
        CloseableHttpClient httpClient = this.getCloseableHttpClient();
        CloseableHttpResponse response = null;
        try {
            HttpPost httpPost = new HttpPost(url);
            RequestConfig requestConfig = this.parseRequestConfig();
            httpPost.setConfig(requestConfig);
            StringEntity requestEntity = new StringEntity(jsonBody, "utf-8");
            requestEntity.setContentEncoding("UTF-8");
            httpPost.setHeader("Content-type", "application/json");
            httpPost.setEntity((HttpEntity)requestEntity);
            response = httpClient.execute((HttpUriRequest)httpPost);
            HttpEntity entity = response.getEntity();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("http client post success. url: {}. latency: {}ms.", url, System.currentTimeMillis() - start);
            }
            T t = JSON.parseObject(EntityUtils.toString((HttpEntity)entity), tClass);
            return t;
        }
        catch (Throwable throwable) {
            LOGGER.error("http client post error. url: " + url + ", body: " + jsonBody + ". latency: " + (System.currentTimeMillis() - start) + "ms.", throwable);
            throw throwable;
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException e) {
                    LOGGER.error("http client post close response error.", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CloseableHttpClient getCloseableHttpClient() {
        if (this.closeableHttpClient == null) {
            RpcHttpClient rpcHttpClient = this;
            synchronized (rpcHttpClient) {
                if (this.closeableHttpClient == null) {
                    PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
                    this.closeableHttpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connectionManager).build();
                }
            }
        }
        return this.closeableHttpClient;
    }

    private RequestConfig parseRequestConfig() {
        return RequestConfig.custom().build();
    }

    private void shutdownHttpClientHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    if (RpcHttpClient.this.closeableHttpClient != null) {
                        RpcHttpClient.this.closeableHttpClient.close();
                    }
                }
                catch (IOException e) {
                    LOGGER.warn("http client close closeableHttpClient error when shutdown jvm.", e);
                }
            }
        });
    }
}

