/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.config;

import com.alipay.sofa.rpc.common.RpcConfigs;
import com.alipay.sofa.rpc.common.struct.Cache;
import com.alipay.sofa.rpc.common.utils.BeanUtils;
import com.alipay.sofa.rpc.common.utils.CommonUtils;
import com.alipay.sofa.rpc.common.utils.CompatibleTypeUtils;
import com.alipay.sofa.rpc.common.utils.ExceptionUtils;
import com.alipay.sofa.rpc.common.utils.ReflectUtils;
import com.alipay.sofa.rpc.common.utils.StringUtils;
import com.alipay.sofa.rpc.config.AbstractIdConfig;
import com.alipay.sofa.rpc.config.ApplicationConfig;
import com.alipay.sofa.rpc.config.ConfigValueHelper;
import com.alipay.sofa.rpc.config.MethodConfig;
import com.alipay.sofa.rpc.config.RegistryConfig;
import com.alipay.sofa.rpc.core.exception.SofaRpcRuntimeException;
import com.alipay.sofa.rpc.filter.Filter;
import com.alipay.sofa.rpc.listener.ConfigListener;
import com.alipay.sofa.rpc.log.LogCodes;
import com.alipay.sofa.rpc.log.Logger;
import com.alipay.sofa.rpc.log.LoggerFactory;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class AbstractInterfaceConfig<T, S extends AbstractInterfaceConfig<T, S>>
extends AbstractIdConfig<S>
implements Serializable {
    private static final long serialVersionUID = -8738241729920479618L;
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractInterfaceConfig.class);
    protected ApplicationConfig application = new ApplicationConfig();
    protected String interfaceId;
    protected String uniqueId = RpcConfigs.getStringValue("default.uniqueId");
    protected transient List<Filter> filterRef;
    protected List<String> filter;
    protected List<RegistryConfig> registry;
    protected Map<String, MethodConfig> methods;
    protected String serialization = RpcConfigs.getStringValue("default.serialization");
    protected boolean register = RpcConfigs.getBooleanValue("service.register");
    protected boolean subscribe = RpcConfigs.getBooleanValue("service.subscribe");
    protected String proxy = RpcConfigs.getStringValue("default.proxy");
    @Deprecated
    protected String group = RpcConfigs.getStringValue("default.group");
    protected String version = RpcConfigs.getStringValue("default.version");
    protected transient Cache cacheRef;
    protected transient T mockRef;
    protected Map<String, String> parameters;
    protected boolean cache;
    protected String mockMode;
    protected boolean mock;
    protected boolean validation;
    protected String compress;
    protected String virtualInterfaceId;
    protected volatile transient Map<String, Object> configValueCache = null;
    protected volatile transient Class proxyClass;
    protected volatile transient ConfigListener configListener;

    protected abstract Class<?> getProxyClass();

    protected abstract String buildKey();

    public S setProxyClass(Class proxyClass) {
        this.proxyClass = proxyClass;
        return (S)((AbstractInterfaceConfig)this.castThis());
    }

    public ApplicationConfig getApplication() {
        if (this.application == null) {
            this.application = new ApplicationConfig();
        }
        return this.application;
    }

    public S setApplication(ApplicationConfig application) {
        if (application == null) {
            application = new ApplicationConfig();
        }
        this.application = application;
        return (S)((AbstractInterfaceConfig)this.castThis());
    }

    public String getInterfaceId() {
        if (StringUtils.isNotBlank(this.virtualInterfaceId)) {
            return this.virtualInterfaceId;
        }
        return this.interfaceId;
    }

    public S setInterfaceId(String interfaceId) {
        this.interfaceId = interfaceId;
        return (S)((AbstractInterfaceConfig)this.castThis());
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    public S setUniqueId(String uniqueId) {
        ConfigValueHelper.checkNormalWithCommaColon("uniqueId", uniqueId);
        this.uniqueId = uniqueId;
        return (S)((AbstractInterfaceConfig)this.castThis());
    }

    public List<Filter> getFilterRef() {
        return this.filterRef;
    }

    public S setFilterRef(List<Filter> filterRef) {
        this.filterRef = filterRef;
        return (S)((AbstractInterfaceConfig)this.castThis());
    }

    public List<String> getFilter() {
        return this.filter;
    }

    public S setFilter(List<String> filter) {
        this.filter = filter;
        return (S)((AbstractInterfaceConfig)this.castThis());
    }

    public List<RegistryConfig> getRegistry() {
        return this.registry;
    }

    public S setRegistry(List<RegistryConfig> registry) {
        this.registry = registry;
        return (S)((AbstractInterfaceConfig)this.castThis());
    }

    public Map<String, MethodConfig> getMethods() {
        return this.methods;
    }

    public S setMethods(Map<String, MethodConfig> methods) {
        this.methods = methods;
        return (S)((AbstractInterfaceConfig)this.castThis());
    }

    public String getSerialization() {
        return this.serialization;
    }

    public S setSerialization(String serialization) {
        this.serialization = serialization;
        return (S)((AbstractInterfaceConfig)this.castThis());
    }

    public boolean isRegister() {
        return this.register;
    }

    public S setRegister(boolean register) {
        this.register = register;
        return (S)((AbstractInterfaceConfig)this.castThis());
    }

    public boolean isSubscribe() {
        return this.subscribe;
    }

    public S setSubscribe(boolean subscribe) {
        this.subscribe = subscribe;
        return (S)((AbstractInterfaceConfig)this.castThis());
    }

    public String getProxy() {
        return this.proxy;
    }

    public S setProxy(String proxy) {
        this.proxy = proxy;
        return (S)((AbstractInterfaceConfig)this.castThis());
    }

    @Deprecated
    public String getGroup() {
        return this.group;
    }

    @Deprecated
    public S setGroup(String group) {
        this.group = group;
        return (S)((AbstractInterfaceConfig)this.castThis());
    }

    @Deprecated
    public String getVersion() {
        return this.version;
    }

    @Deprecated
    public S setVersion(String version) {
        this.version = version;
        return (S)((AbstractInterfaceConfig)this.castThis());
    }

    public Cache getCacheRef() {
        return this.cacheRef;
    }

    public S setCacheRef(Cache cacheRef) {
        this.cacheRef = cacheRef;
        return (S)((AbstractInterfaceConfig)this.castThis());
    }

    public T getMockRef() {
        return this.mockRef;
    }

    public S setMockRef(T mockRef) {
        this.mockRef = mockRef;
        return (S)((AbstractInterfaceConfig)this.castThis());
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public S setParameters(Map<String, String> parameters) {
        if (this.parameters == null) {
            this.parameters = new ConcurrentHashMap<String, String>();
        }
        this.parameters.putAll(parameters);
        return (S)((AbstractInterfaceConfig)this.castThis());
    }

    public String getMockMode() {
        return this.mockMode;
    }

    public S setMockMode(String mockMode) {
        this.mockMode = mockMode;
        if (StringUtils.equals(mockMode, "local") || StringUtils.equals(mockMode, "remote")) {
            this.setMock(true);
        }
        return (S)((AbstractInterfaceConfig)this.castThis());
    }

    public boolean isMock() {
        return this.mock;
    }

    public S setMock(boolean mock) {
        this.mock = mock;
        return (S)((AbstractInterfaceConfig)this.castThis());
    }

    public boolean isValidation() {
        return this.validation;
    }

    public S setValidation(boolean validation) {
        this.validation = validation;
        return (S)((AbstractInterfaceConfig)this.castThis());
    }

    public String getCompress() {
        return this.compress;
    }

    public S setCompress(String compress) {
        this.compress = compress;
        return (S)((AbstractInterfaceConfig)this.castThis());
    }

    public boolean isCache() {
        return this.cache;
    }

    public S setCache(boolean cache) {
        this.cache = cache;
        return (S)((AbstractInterfaceConfig)this.castThis());
    }

    public Map<String, Object> getConfigValueCache() {
        return this.configValueCache;
    }

    public S setConfigListener(ConfigListener configListener) {
        this.configListener = configListener;
        return (S)((AbstractInterfaceConfig)this.castThis());
    }

    public ConfigListener getConfigListener() {
        return this.configListener;
    }

    public abstract boolean hasTimeout();

    public abstract boolean hasConcurrents();

    public boolean hasValidation() {
        if (this.validation) {
            return true;
        }
        if (CommonUtils.isNotEmpty(this.methods)) {
            for (MethodConfig methodConfig : this.methods.values()) {
                if (!CommonUtils.isTrue(methodConfig.getValidation())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasCache() {
        if (this.isCache()) {
            return true;
        }
        if (CommonUtils.isNotEmpty(this.methods)) {
            for (MethodConfig methodConfig : this.methods.values()) {
                if (!CommonUtils.isTrue(methodConfig.getCache())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasToken() {
        if (this.getParameter(".token") != null) {
            return true;
        }
        if (CommonUtils.isNotEmpty(this.methods)) {
            for (MethodConfig methodConfig : this.methods.values()) {
                if (methodConfig.getParameter(".token") == null) continue;
                return true;
            }
        }
        return false;
    }

    public S setMethods(List<MethodConfig> methods) {
        if (this.methods == null) {
            this.methods = new ConcurrentHashMap<String, MethodConfig>();
        }
        if (methods != null) {
            for (MethodConfig methodConfig : methods) {
                this.methods.put(methodConfig.getName(), methodConfig);
            }
        }
        return (S)((AbstractInterfaceConfig)this.castThis());
    }

    public S setRegistry(RegistryConfig registry) {
        if (this.registry == null) {
            this.registry = new ArrayList<RegistryConfig>();
        }
        this.registry.add(registry);
        return (S)((AbstractInterfaceConfig)this.castThis());
    }

    private MethodConfig getMethodConfig(String methodName) {
        if (this.methods == null) {
            return null;
        }
        return this.methods.get(methodName);
    }

    public synchronized Map<String, Object> getConfigValueCache(boolean rebuild) {
        Map<String, MethodConfig> methodConfigs;
        if (this.configValueCache != null && !rebuild) {
            return this.configValueCache;
        }
        HashMap<String, Object> context = new HashMap<String, Object>(32);
        Map<String, String> providerParams = this.getParameters();
        if (providerParams != null) {
            context.putAll(providerParams);
        }
        if (CommonUtils.isNotEmpty(methodConfigs = this.getMethods())) {
            for (MethodConfig methodConfig : methodConfigs.values()) {
                String prefix = '.' + methodConfig.getName() + '.';
                Map<String, String> methodparam = methodConfig.getParameters();
                if (methodparam != null) {
                    for (Map.Entry<String, String> entry : methodparam.entrySet()) {
                        context.put(prefix + entry.getKey(), entry.getValue());
                    }
                }
                BeanUtils.copyPropertiesToMap(methodConfig, prefix, context);
            }
        }
        BeanUtils.copyPropertiesToMap(this, "", context);
        this.configValueCache = Collections.unmodifiableMap(context);
        return this.configValueCache;
    }

    public String queryAttribute(String property) {
        try {
            Object oldValue = null;
            if (property.charAt(0) == '.') {
                String methodAndP = property.substring(1);
                int index = methodAndP.indexOf(46);
                if (index <= 0) {
                    throw ExceptionUtils.buildRuntime(property, "", "Unknown query attribute key!");
                }
                String methodName = methodAndP.substring(0, index);
                String methodProperty = methodAndP.substring(index + 1);
                MethodConfig methodConfig = this.getMethodConfig(methodName);
                if (methodConfig != null) {
                    Method getMethod = ReflectUtils.getPropertyGetterMethod(MethodConfig.class, methodProperty);
                    Class<?> propertyClazz = getMethod.getReturnType();
                    oldValue = BeanUtils.getProperty(methodConfig, methodProperty, propertyClazz);
                }
            } else {
                Method getMethod = ReflectUtils.getPropertyGetterMethod(this.getClass(), property);
                Class<?> propertyClazz = getMethod.getReturnType();
                oldValue = BeanUtils.getProperty(this, property, propertyClazz);
            }
            return oldValue == null ? null : oldValue.toString();
        }
        catch (SofaRpcRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SofaRpcRuntimeException(LogCodes.getLog("019990025", property), e);
        }
    }

    public boolean updateAttribute(String property, String newValueStr, boolean overwrite) {
        try {
            boolean changed = false;
            if (property.charAt(0) == '.') {
                String methodAndP = property.substring(1);
                int index = methodAndP.indexOf(46);
                if (index <= 0) {
                    throw ExceptionUtils.buildRuntime(property, newValueStr, "Unknown update attribute key!");
                }
                String methodName = methodAndP.substring(0, index);
                String methodProperty = methodAndP.substring(index + 1);
                MethodConfig methodConfig = this.getMethodConfig(methodName);
                Method getMethod = ReflectUtils.getPropertyGetterMethod(MethodConfig.class, methodProperty);
                Class<?> propertyClazz = getMethod.getReturnType();
                Object oldValue = null;
                Object newValue = CompatibleTypeUtils.convert(newValueStr, propertyClazz);
                if (methodConfig == null) {
                    methodConfig = new MethodConfig();
                    methodConfig.setName(methodName);
                    if (this.methods == null) {
                        this.methods = new ConcurrentHashMap<String, MethodConfig>();
                    }
                    this.methods.put(methodName, methodConfig);
                    changed = true;
                } else {
                    oldValue = BeanUtils.getProperty(methodConfig, methodProperty, propertyClazz);
                    if (oldValue == null) {
                        if (newValueStr != null) {
                            changed = true;
                        }
                    } else {
                        boolean bl = changed = !oldValue.equals(newValue);
                    }
                }
                if (changed && overwrite) {
                    BeanUtils.setProperty(methodConfig, methodProperty, propertyClazz, newValue);
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info("Property \"" + methodName + "." + methodProperty + "\" changed from {} to {}", oldValue, newValueStr);
                    }
                }
            } else {
                Method getMethod = ReflectUtils.getPropertyGetterMethod(this.getClass(), property);
                Class<?> propertyClazz = getMethod.getReturnType();
                Object oldValue = BeanUtils.getProperty(this, property, propertyClazz);
                Object newValue = CompatibleTypeUtils.convert(newValueStr, propertyClazz);
                if (oldValue == null) {
                    if (newValueStr != null) {
                        changed = true;
                    }
                } else {
                    boolean bl = changed = !oldValue.equals(newValue);
                }
                if (changed && overwrite) {
                    BeanUtils.setProperty(this, property, propertyClazz, newValue);
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info("Property \"" + property + "\" changed from {} to {}", oldValue, newValueStr);
                    }
                }
            }
            return changed;
        }
        catch (SofaRpcRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SofaRpcRuntimeException(LogCodes.getLog("019990026", property, newValueStr), e);
        }
    }

    public Object getMethodConfigValue(String methodName, String configKey, Object defaultValue) {
        Object value = this.getMethodConfigValue(methodName, configKey);
        return value == null ? defaultValue : value;
    }

    public Object getMethodConfigValue(String methodName, String configKey) {
        if (this.configValueCache == null) {
            return null;
        }
        String key = this.buildmkey(methodName, configKey);
        return this.configValueCache.get(key);
    }

    private String buildmkey(String methodName, String key) {
        return '.' + methodName + '.' + key;
    }

    public S setParameter(String key, String value) {
        if (this.parameters == null) {
            this.parameters = new ConcurrentHashMap<String, String>();
        }
        if (value == null) {
            this.parameters.remove(key);
        } else {
            this.parameters.put(key, value);
        }
        return (S)((AbstractInterfaceConfig)this.castThis());
    }

    public String getParameter(String key) {
        return this.parameters == null ? null : this.parameters.get(key);
    }

    public String getAppName() {
        return this.application.getAppName();
    }

    public String getVirtualInterfaceId() {
        return this.virtualInterfaceId;
    }

    public void setVirtualInterfaceId(String virtualInterfaceId) {
        this.virtualInterfaceId = virtualInterfaceId;
    }
}

