/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.metrics.lookout;

import com.alipay.lookout.api.Id;
import com.alipay.lookout.api.Lookout;
import com.alipay.sofa.rpc.config.ServerConfig;
import com.alipay.sofa.rpc.metrics.lookout.RpcLookout;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class RpcLookoutId {
    private final ConcurrentMap<String, Id> consumerIds = new ConcurrentHashMap<String, Id>();
    private final ConcurrentMap<String, Id> providerIds = new ConcurrentHashMap<String, Id>();
    private final ConcurrentMap<String, Id> serverConfigIds = new ConcurrentHashMap<String, Id>();
    private volatile Id consumerConfigId;
    private final Object consumerConfigIdLock = new Object();
    private volatile Id providerConfigId;
    private final Object providerConfigIdLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Id fetchConsumerStatId(Map<String, String> tags) {
        String key = tags.toString();
        Id lookoutId = (Id)this.consumerIds.get(key);
        if (lookoutId != null) return lookoutId;
        Class<RpcLookoutId> clazz = RpcLookoutId.class;
        synchronized (RpcLookoutId.class) {
            lookoutId = (Id)this.consumerIds.get(key);
            if (lookoutId != null) return lookoutId;
            lookoutId = Lookout.registry().createId("rpc.consumer.service.stats", tags);
            this.consumerIds.put(key, lookoutId);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return lookoutId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Id fetchProviderStatId(Map<String, String> tags) {
        String key = tags.toString();
        Id lookoutId = (Id)this.providerIds.get(key);
        if (lookoutId != null) return lookoutId;
        Class<RpcLookoutId> clazz = RpcLookoutId.class;
        synchronized (RpcLookoutId.class) {
            lookoutId = (Id)this.providerIds.get(key);
            if (lookoutId != null) return lookoutId;
            lookoutId = Lookout.registry().createId("rpc.provider.service.stats", tags);
            this.providerIds.put(key, lookoutId);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return lookoutId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Id fetchConsumerSubId() {
        if (this.consumerConfigId == null) {
            Object object = this.consumerConfigIdLock;
            synchronized (object) {
                if (this.consumerConfigId == null) {
                    this.consumerConfigId = Lookout.registry().createId("rpc.consumer.info.stats");
                }
            }
        }
        return this.consumerConfigId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Id fetchProviderPubId() {
        if (this.providerConfigId == null) {
            Object object = this.providerConfigIdLock;
            synchronized (object) {
                if (this.providerConfigId == null) {
                    this.providerConfigId = Lookout.registry().createId("rpc.provider.info.stats");
                }
            }
        }
        return this.providerConfigId;
    }

    public synchronized Id fetchServerThreadConfigId(ServerConfig serverConfig) {
        String key = "rpc." + serverConfig.getProtocol() + ".threadpool.config";
        return this.fetchServerConfigId(key);
    }

    public Id fetchServerThreadPoolActiveCountId(ServerConfig serverConfig) {
        String key = "rpc." + serverConfig.getProtocol() + ".threadpool.active.count";
        return this.fetchServerConfigId(key);
    }

    public Id fetchServerThreadPoolIdleCountId(ServerConfig serverConfig) {
        String key = "rpc." + serverConfig.getProtocol() + ".threadpool.idle.count";
        return this.fetchServerConfigId(key);
    }

    public Id fetchServerThreadPoolQueueSizeId(ServerConfig serverConfig) {
        String key = "rpc." + serverConfig.getProtocol() + ".threadpool.queue.size";
        return this.fetchServerConfigId(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Id fetchServerConfigId(String key) {
        Id lookoutId = (Id)this.serverConfigIds.get(key);
        if (lookoutId != null) return lookoutId;
        Class<RpcLookout> clazz = RpcLookout.class;
        synchronized (RpcLookout.class) {
            lookoutId = (Id)this.serverConfigIds.get(key);
            if (lookoutId != null) return lookoutId;
            lookoutId = Lookout.registry().createId(key);
            this.serverConfigIds.put(key, lookoutId);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return lookoutId;
        }
    }

    public Id removeServerThreadConfigId(ServerConfig serverConfig) {
        String key = "rpc." + serverConfig.getProtocol() + ".threadpool.config";
        return (Id)this.serverConfigIds.remove(key);
    }

    public Id removeServerThreadPoolActiveCountId(ServerConfig serverConfig) {
        String key = "rpc." + serverConfig.getProtocol() + ".threadpool.active.count";
        return (Id)this.serverConfigIds.remove(key);
    }

    public Id removeServerThreadPoolIdleCountId(ServerConfig serverConfig) {
        String key = "rpc." + serverConfig.getProtocol() + ".threadpool.idle.count";
        return (Id)this.serverConfigIds.remove(key);
    }

    public Id removeServerThreadPoolQueueSizeId(ServerConfig serverConfig) {
        String key = "rpc." + serverConfig.getProtocol() + ".threadpool.queue.size";
        return (Id)this.serverConfigIds.remove(key);
    }
}

