/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.server;

import com.alipay.sofa.rpc.common.struct.NamedThreadFactory;
import com.alipay.sofa.rpc.common.utils.ThreadPoolUtils;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class UserThreadPool {
    public static final String DEFAUT_POOL_NAME = "SofaUserProcessor";
    private static final AtomicInteger POOL_NAME_COUNTER = new AtomicInteger(0);
    private int corePoolSize = 10;
    private int maximumPoolSize = 100;
    private int keepAliveTime = 300000;
    private int queueSize = 0;
    private String threadPoolName;
    private boolean allowCoreThreadTimeOut;
    private boolean prestartAllCoreThreads;
    volatile transient ThreadPoolExecutor executor;

    public UserThreadPool() {
        this.threadPoolName = "SofaUserProcessor-" + POOL_NAME_COUNTER.getAndIncrement();
    }

    public UserThreadPool(String uniqueThreadPoolName) {
        this.threadPoolName = uniqueThreadPoolName;
    }

    public void init() {
        this.executor = new ThreadPoolExecutor(this.corePoolSize, this.maximumPoolSize, (long)this.keepAliveTime, TimeUnit.MILLISECONDS, ThreadPoolUtils.buildQueue(this.queueSize), new NamedThreadFactory(this.threadPoolName));
        if (this.allowCoreThreadTimeOut) {
            this.executor.allowCoreThreadTimeOut(true);
        }
        if (this.prestartAllCoreThreads) {
            this.executor.prestartAllCoreThreads();
        }
    }

    public void destroy() {
        if (this.executor != null) {
            this.executor.shutdown();
        }
    }

    public int getCorePoolSize() {
        return this.corePoolSize;
    }

    public UserThreadPool setCorePoolSize(int corePoolSize) {
        this.corePoolSize = corePoolSize;
        return this;
    }

    public int getMaximumPoolSize() {
        return this.maximumPoolSize;
    }

    public UserThreadPool setMaximumPoolSize(int maximumPoolSize) {
        this.maximumPoolSize = maximumPoolSize;
        return this;
    }

    public int getQueueSize() {
        return this.queueSize;
    }

    public UserThreadPool setQueueSize(int queueSize) {
        this.queueSize = queueSize;
        return this;
    }

    public String getThreadPoolName() {
        return this.threadPoolName;
    }

    public UserThreadPool setThreadPoolName(String threadPoolName) {
        this.threadPoolName = threadPoolName;
        return this;
    }

    public boolean isAllowCoreThreadTimeOut() {
        return this.allowCoreThreadTimeOut;
    }

    public UserThreadPool setAllowCoreThreadTimeOut(boolean allowCoreThreadTimeOut) {
        this.allowCoreThreadTimeOut = allowCoreThreadTimeOut;
        return this;
    }

    public boolean isPrestartAllCoreThreads() {
        return this.prestartAllCoreThreads;
    }

    public UserThreadPool setPrestartAllCoreThreads(boolean prestartAllCoreThreads) {
        this.prestartAllCoreThreads = prestartAllCoreThreads;
        return this;
    }

    public int getKeepAliveTime() {
        return this.keepAliveTime;
    }

    public UserThreadPool setKeepAliveTime(int keepAliveTime) {
        this.keepAliveTime = keepAliveTime;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ThreadPoolExecutor getExecutor() {
        if (this.executor == null) {
            UserThreadPool userThreadPool = this;
            synchronized (userThreadPool) {
                if (this.executor == null) {
                    this.init();
                }
            }
        }
        return this.executor;
    }
}

