/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.server.triple;

import com.alipay.sofa.rpc.codec.Serializer;
import com.alipay.sofa.rpc.codec.SerializerFactory;
import com.alipay.sofa.rpc.common.utils.ClassTypeUtils;
import com.alipay.sofa.rpc.common.utils.ClassUtils;
import com.alipay.sofa.rpc.core.exception.SofaRpcException;
import com.alipay.sofa.rpc.core.exception.SofaRpcRuntimeException;
import com.alipay.sofa.rpc.core.request.SofaRequest;
import com.alipay.sofa.rpc.core.response.SofaResponse;
import com.alipay.sofa.rpc.invoke.Invoker;
import com.alipay.sofa.rpc.log.Logger;
import com.alipay.sofa.rpc.log.LoggerFactory;
import com.alipay.sofa.rpc.tracer.sofatracer.TracingContextKey;
import com.alipay.sofa.rpc.transport.AbstractByteBuf;
import com.alipay.sofa.rpc.transport.ByteArrayWrapperByteBuf;
import com.google.protobuf.ByteString;
import com.google.protobuf.ProtocolStringList;
import io.grpc.Context;
import io.grpc.stub.StreamObserver;
import java.lang.reflect.Method;
import java.util.List;
import triple.Request;
import triple.Response;
import triple.SofaGenericServiceTriple;

public class GenericServiceImpl
extends SofaGenericServiceTriple.GenericServiceImplBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(GenericServiceImpl.class);
    protected Invoker invoker;
    protected Class proxyClass;

    public GenericServiceImpl(Invoker invoker, Class proxyClass) {
        this.invoker = invoker;
        this.proxyClass = proxyClass;
    }

    @Override
    public void generic(Request request, StreamObserver<Response> responseObserver) {
        SofaRequest sofaRequest = (SofaRequest)TracingContextKey.getKeySofaRequest().get(Context.current());
        String methodName = sofaRequest.getMethodName();
        String interfaceName = sofaRequest.getInterfaceName();
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Class proxyClass = ClassTypeUtils.getClass(interfaceName);
            ClassLoader interfaceClassLoader = proxyClass.getClassLoader();
            Thread.currentThread().setContextClassLoader(interfaceClassLoader);
            Class[] argTypes = this.getArgTypes(request);
            Serializer serializer = SerializerFactory.getSerializer(request.getSerializeType());
            Method declaredMethod = proxyClass.getDeclaredMethod(methodName, argTypes);
            Object[] invokeArgs = this.getInvokeArgs(request, argTypes, serializer);
            sofaRequest.setMethod(declaredMethod);
            sofaRequest.setMethodArgs(invokeArgs);
            sofaRequest.setMethodArgSigs(ClassTypeUtils.getTypeStrs(argTypes, true));
            SofaResponse response = this.invoker.invoke(sofaRequest);
            Object ret = this.getAppResponse(declaredMethod, response);
            Response.Builder builder = Response.newBuilder();
            builder.setSerializeType(request.getSerializeType());
            builder.setType(declaredMethod.getReturnType().getName());
            builder.setData(ByteString.copyFrom((byte[])serializer.encode(ret, null).array()));
            Response build = builder.build();
            responseObserver.onNext((Object)build);
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            LOGGER.error("Invoke " + methodName + " error:", e);
            throw new SofaRpcRuntimeException(e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    private Object getAppResponse(Method method, SofaResponse response) {
        if (response.isError()) {
            throw new SofaRpcException(199, response.getErrorMsg());
        }
        Object ret = response.getAppResponse();
        if (ret instanceof Throwable) {
            throw new SofaRpcRuntimeException((Throwable)ret);
        }
        if (ret == null) {
            ret = ClassUtils.getDefaultPrimitiveValue(method.getReturnType());
        }
        return ret;
    }

    private Class[] getArgTypes(Request request) {
        ProtocolStringList argTypesList = request.getArgTypesList();
        int size = argTypesList.size();
        Class[] argTypes = new Class[size];
        for (int i = 0; i < size; ++i) {
            String typeName = (String)argTypesList.get(i);
            argTypes[i] = ClassTypeUtils.getClass(typeName);
        }
        return argTypes;
    }

    private Object[] getInvokeArgs(Request request, Class[] argTypes, Serializer serializer) {
        List<ByteString> argsList = request.getArgsList();
        Object[] args = new Object[argsList.size()];
        for (int i = 0; i < argsList.size(); ++i) {
            byte[] data = argsList.get(i).toByteArray();
            args[i] = serializer.decode((AbstractByteBuf)new ByteArrayWrapperByteBuf(data), argTypes[i], null);
        }
        return args;
    }
}

