/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.transport.bolt;

import com.alipay.remoting.Connection;
import com.alipay.remoting.InvokeCallback;
import com.alipay.remoting.InvokeContext;
import com.alipay.remoting.Url;
import com.alipay.remoting.exception.ConnectionClosedException;
import com.alipay.remoting.exception.DeserializationException;
import com.alipay.remoting.exception.RemotingException;
import com.alipay.remoting.exception.SerializationException;
import com.alipay.remoting.rpc.RpcClient;
import com.alipay.remoting.rpc.exception.InvokeSendFailedException;
import com.alipay.remoting.rpc.exception.InvokeServerBusyException;
import com.alipay.remoting.rpc.exception.InvokeServerException;
import com.alipay.remoting.rpc.exception.InvokeTimeoutException;
import com.alipay.sofa.rpc.client.ProviderInfo;
import com.alipay.sofa.rpc.codec.bolt.SofaRpcSerializationRegister;
import com.alipay.sofa.rpc.common.RpcConfigs;
import com.alipay.sofa.rpc.common.utils.ClassLoaderUtils;
import com.alipay.sofa.rpc.context.RpcInternalContext;
import com.alipay.sofa.rpc.context.RpcInvokeContext;
import com.alipay.sofa.rpc.core.exception.SofaRpcException;
import com.alipay.sofa.rpc.core.exception.SofaRpcRuntimeException;
import com.alipay.sofa.rpc.core.exception.SofaTimeOutException;
import com.alipay.sofa.rpc.core.invoke.SofaResponseCallback;
import com.alipay.sofa.rpc.core.request.SofaRequest;
import com.alipay.sofa.rpc.core.response.SofaResponse;
import com.alipay.sofa.rpc.event.ClientAfterSendEvent;
import com.alipay.sofa.rpc.event.ClientBeforeSendEvent;
import com.alipay.sofa.rpc.event.ClientSyncReceiveEvent;
import com.alipay.sofa.rpc.event.EventBus;
import com.alipay.sofa.rpc.ext.Extension;
import com.alipay.sofa.rpc.log.LogCodes;
import com.alipay.sofa.rpc.log.Logger;
import com.alipay.sofa.rpc.log.LoggerFactory;
import com.alipay.sofa.rpc.message.ResponseFuture;
import com.alipay.sofa.rpc.message.bolt.BoltFutureInvokeCallback;
import com.alipay.sofa.rpc.message.bolt.BoltInvokerCallback;
import com.alipay.sofa.rpc.message.bolt.BoltResponseFuture;
import com.alipay.sofa.rpc.transport.AbstractChannel;
import com.alipay.sofa.rpc.transport.ClientTransport;
import com.alipay.sofa.rpc.transport.ClientTransportConfig;
import com.alipay.sofa.rpc.transport.bolt.AloneBoltClientConnectionManager;
import com.alipay.sofa.rpc.transport.bolt.BoltClientConnectionManager;
import com.alipay.sofa.rpc.transport.bolt.ReuseBoltClientConnectionManager;
import java.net.InetSocketAddress;
import java.util.concurrent.atomic.AtomicInteger;

@Extension(value="bolt")
public class BoltClientTransport
extends ClientTransport {
    private static final Logger LOGGER = LoggerFactory.getLogger(BoltClientTransport.class);
    protected static final RpcClient RPC_CLIENT = new RpcClient();
    protected static final boolean REUSE_CONNECTION = RpcConfigs.getOrDefaultValue("transport.connection.reuse", true);
    protected static BoltClientConnectionManager connectionManager = REUSE_CONNECTION ? new ReuseBoltClientConnectionManager(true) : new AloneBoltClientConnectionManager(true);
    protected final Url url;
    protected volatile AtomicInteger currentRequests = new AtomicInteger(0);

    protected BoltClientTransport(ClientTransportConfig transportConfig) {
        super(transportConfig);
        this.url = this.convertProviderToUrl(transportConfig, transportConfig.getProviderInfo());
    }

    protected Url convertProviderToUrl(ClientTransportConfig transportConfig, ProviderInfo providerInfo) {
        Url boltUrl = new Url(providerInfo.toString(), providerInfo.getHost(), providerInfo.getPort());
        boltUrl.setConnectTimeout(transportConfig.getConnectTimeout());
        int connectionNum = transportConfig.getConnectionNum();
        if (connectionNum > 0) {
            boltUrl.setConnNum(connectionNum);
        } else {
            boltUrl.setConnNum(1);
        }
        boltUrl.setConnWarmup(false);
        if ("bolt".equals(providerInfo.getProtocolType())) {
            boltUrl.setProtocol((byte)1);
        } else {
            boltUrl.setProtocol((byte)13);
        }
        return boltUrl;
    }

    @Override
    public void connect() {
        this.fetchConnection();
    }

    @Override
    public void disconnect() {
        try {
            connectionManager.closeConnection(RPC_CLIENT, this.transportConfig, this.url);
        }
        catch (SofaRpcRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SofaRpcRuntimeException(LogCodes.getLog("020010014"), e);
        }
    }

    @Override
    public void destroy() {
        this.disconnect();
    }

    @Override
    public boolean isAvailable() {
        return connectionManager.isConnectionFine(RPC_CLIENT, this.transportConfig, this.url);
    }

    @Override
    public void setChannel(AbstractChannel channel) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public AbstractChannel getChannel() {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public int currentRequests() {
        return this.currentRequests.get();
    }

    @Override
    public ResponseFuture asyncSend(SofaRequest request, int timeout) throws SofaRpcException {
        this.checkConnection();
        RpcInternalContext context = RpcInternalContext.getContext();
        InvokeContext boltInvokeContext = this.createInvokeContext(request);
        try {
            this.beforeSend(context, request);
            boltInvokeContext.put("rpc.ctx", (Object)context);
            ResponseFuture responseFuture = this.doInvokeAsync(request, context, boltInvokeContext, timeout);
            return responseFuture;
        }
        catch (Exception e) {
            throw this.convertToRpcException(e);
        }
        finally {
            this.afterSend(context, boltInvokeContext, request);
        }
    }

    protected ResponseFuture doInvokeAsync(SofaRequest request, RpcInternalContext rpcContext, InvokeContext invokeContext, int timeoutMillis) throws RemotingException, InterruptedException {
        SofaResponseCallback listener = request.getSofaResponseCallback();
        if (listener != null) {
            BoltInvokerCallback callback = new BoltInvokerCallback(this.transportConfig.getConsumerConfig(), this.transportConfig.getProviderInfo(), listener, request, rpcContext, ClassLoaderUtils.getCurrentClassLoader());
            RPC_CLIENT.invokeWithCallback(this.url, (Object)request, invokeContext, (InvokeCallback)callback, timeoutMillis);
            return null;
        }
        BoltResponseFuture future = new BoltResponseFuture(request, timeoutMillis);
        BoltFutureInvokeCallback callback = new BoltFutureInvokeCallback(this.transportConfig.getConsumerConfig(), this.transportConfig.getProviderInfo(), future, request, rpcContext, ClassLoaderUtils.getCurrentClassLoader());
        RPC_CLIENT.invokeWithCallback(this.url, (Object)request, invokeContext, (InvokeCallback)callback, timeoutMillis);
        future.setSentTime();
        return future;
    }

    @Override
    public SofaResponse syncSend(SofaRequest request, int timeout) throws SofaRpcException {
        this.checkConnection();
        RpcInternalContext context = RpcInternalContext.getContext();
        InvokeContext boltInvokeContext = this.createInvokeContext(request);
        SofaResponse response = null;
        SofaRpcException throwable = null;
        try {
            this.beforeSend(context, request);
            SofaResponse sofaResponse = response = this.doInvokeSync(request, boltInvokeContext, timeout);
            return sofaResponse;
        }
        catch (Exception e) {
            throwable = this.convertToRpcException(e);
            throw throwable;
        }
        finally {
            this.afterSend(context, boltInvokeContext, request);
            if (EventBus.isEnable(ClientSyncReceiveEvent.class)) {
                EventBus.post(new ClientSyncReceiveEvent(this.transportConfig.getConsumerConfig(), this.transportConfig.getProviderInfo(), request, response, throwable));
            }
        }
    }

    protected SofaResponse doInvokeSync(SofaRequest request, InvokeContext invokeContext, int timeoutMillis) throws RemotingException, InterruptedException {
        return (SofaResponse)RPC_CLIENT.invokeSync(this.url, (Object)request, invokeContext, timeoutMillis);
    }

    @Override
    public void oneWaySend(SofaRequest request, int timeout) throws SofaRpcException {
        this.checkConnection();
        RpcInternalContext context = RpcInternalContext.getContext();
        InvokeContext invokeContext = this.createInvokeContext(request);
        SofaRpcException throwable = null;
        try {
            this.beforeSend(context, request);
            this.doOneWay(request, invokeContext, timeout);
        }
        catch (Exception e) {
            throwable = this.convertToRpcException(e);
            throw throwable;
        }
        finally {
            this.afterSend(context, invokeContext, request);
            if (EventBus.isEnable(ClientSyncReceiveEvent.class)) {
                EventBus.post(new ClientSyncReceiveEvent(this.transportConfig.getConsumerConfig(), this.transportConfig.getProviderInfo(), request, null, throwable));
            }
        }
    }

    protected void doOneWay(SofaRequest request, InvokeContext invokeContext, int timeoutMillis) throws RemotingException, InterruptedException {
        RPC_CLIENT.oneway(this.url, (Object)request, invokeContext);
    }

    protected SofaRpcException convertToRpcException(Exception e) {
        boolean isServer;
        SofaRpcException exception = e instanceof SofaRpcException ? (SofaRpcException)e : (e instanceof InvokeTimeoutException ? new SofaTimeOutException(e) : (e instanceof InvokeServerBusyException ? new SofaRpcException(100, (Throwable)e) : (e instanceof SerializationException ? ((isServer = ((SerializationException)e).isServerSide()) ? new SofaRpcException(120, (Throwable)e) : new SofaRpcException(220, (Throwable)e)) : (e instanceof DeserializationException ? ((isServer = ((DeserializationException)e).isServerSide()) ? new SofaRpcException(130, (Throwable)e) : new SofaRpcException(230, (Throwable)e)) : (e instanceof ConnectionClosedException ? new SofaRpcException(250, (Throwable)e) : (e instanceof InvokeSendFailedException ? new SofaRpcException(250, (Throwable)e) : (e instanceof InvokeServerException ? new SofaRpcException(199, e.getCause()) : new SofaRpcException(299, (Throwable)e))))))));
        return exception;
    }

    protected InvokeContext createInvokeContext(SofaRequest request) {
        InvokeContext invokeContext = new InvokeContext();
        invokeContext.put("bolt.invoke.custom.serializer", (Object)request.getSerializeType());
        invokeContext.put("sofa_head_target_service", (Object)request.getTargetServiceUniqueName());
        invokeContext.put("sofa_head_method_name", (Object)request.getMethodName());
        String genericType = (String)request.getRequestProp("sofa_head_generic_type");
        if (genericType != null) {
            invokeContext.put("sofa_head_generic_type", (Object)genericType);
        }
        return invokeContext;
    }

    protected void beforeSend(RpcInternalContext context, SofaRequest request) {
        this.currentRequests.incrementAndGet();
        context.setLocalAddress(this.localAddress());
        if (EventBus.isEnable(ClientBeforeSendEvent.class)) {
            EventBus.post(new ClientBeforeSendEvent(request));
        }
    }

    protected void afterSend(RpcInternalContext context, InvokeContext invokeContext, SofaRequest request) {
        this.currentRequests.decrementAndGet();
        if (RpcInternalContext.isAttachmentEnable()) {
            this.putToContextIfNotNull(invokeContext, "bolt.client.conn.createtime", context, "_conn_create_time");
        }
        this.putToContext(invokeContext);
        if (EventBus.isEnable(ClientAfterSendEvent.class)) {
            EventBus.post(new ClientAfterSendEvent(request));
        }
    }

    @Override
    public void receiveRpcResponse(SofaResponse response) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public void handleRpcRequest(SofaRequest request) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public InetSocketAddress remoteAddress() {
        Connection connection = this.fetchConnection();
        return connection == null ? null : connection.getRemoteAddress();
    }

    @Override
    public InetSocketAddress localAddress() {
        Connection connection = this.fetchConnection();
        return connection == null ? null : connection.getLocalAddress();
    }

    protected void checkConnection() throws SofaRpcException {
        Connection connection = this.fetchConnection();
        if (connection == null) {
            throw new SofaRpcException(250, "connection is null");
        }
        if (!connection.isFine()) {
            throw new SofaRpcException(250, "connection is not fine");
        }
    }

    protected void putToContextIfNotNull(InvokeContext invokeContext, String oldKey, RpcInternalContext context, String key) {
        Object value = invokeContext.get(oldKey);
        if (value != null) {
            context.setAttachment(key, value);
        }
    }

    private void putToContext(InvokeContext invokeContext) {
        Long connStartTime = (Long)invokeContext.get("bolt.client.conn.create.start.nano");
        Long connEndTime = (Long)invokeContext.get("bolt.client.conn.create.end.nano");
        if (connStartTime != null && connEndTime != null) {
            RpcInvokeContext.getContext().put("_conn_create_time_nano", connEndTime - connStartTime);
        }
    }

    public Connection fetchConnection() {
        return connectionManager.getConnection(RPC_CLIENT, this.transportConfig, this.url);
    }

    static {
        RPC_CLIENT.init();
        SofaRpcSerializationRegister.registerCustomSerializer();
    }
}

