/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.common.tracer.core.reporter.common;

import com.alipay.common.tracer.core.appender.encoder.SpanEncoder;
import com.alipay.common.tracer.core.appender.file.LoadTestAwareAppender;
import com.alipay.common.tracer.core.appender.manager.AsyncCommonDigestAppenderManager;
import com.alipay.common.tracer.core.appender.self.SelfLog;
import com.alipay.common.tracer.core.configuration.SofaTracerConfiguration;
import com.alipay.common.tracer.core.reporter.common.CommonSpanEncoder;
import com.alipay.common.tracer.core.reporter.type.TracerSystemLogEnum;
import com.alipay.common.tracer.core.span.CommonLogSpan;
import com.alipay.common.tracer.core.utils.StringUtils;
import com.alipay.sofa.common.code.LogCode2Description;

public class CommonTracerManager {
    private static volatile AsyncCommonDigestAppenderManager commonReporterAsyncManager = new AsyncCommonDigestAppenderManager(1024);
    private static SpanEncoder commonSpanEncoder = new CommonSpanEncoder();

    public static void register(String logFileName, String rollingPolicy, String logReserveDay) {
        if (StringUtils.isBlank(logFileName)) {
            return;
        }
        if (commonReporterAsyncManager.isAppenderAndEncoderExist(logFileName)) {
            SelfLog.warn(logFileName + " has existed in CommonTracerManager");
            return;
        }
        LoadTestAwareAppender traceAppender = LoadTestAwareAppender.createLoadTestAwareTimedRollingFileAppender(logFileName, rollingPolicy, logReserveDay);
        commonReporterAsyncManager.addAppender(logFileName, traceAppender, commonSpanEncoder);
    }

    @Deprecated
    public static void register(char logType, String logFileName, String rollingPolicy, String logReserveDay) {
        String logTypeStr = new String(new char[]{logType});
        if (CommonTracerManager.isAppenderExist(logTypeStr)) {
            SelfLog.warn(logTypeStr + " has existed in CommonTracerManager");
            return;
        }
        LoadTestAwareAppender traceAppender = LoadTestAwareAppender.createLoadTestAwareTimedRollingFileAppender(logFileName, rollingPolicy, logReserveDay);
        commonReporterAsyncManager.addAppender(logTypeStr, traceAppender, commonSpanEncoder);
    }

    public static boolean isAppenderExist(String logType) {
        if (StringUtils.isBlank(logType)) {
            return false;
        }
        return commonReporterAsyncManager.isAppenderAndEncoderExist(logType);
    }

    public static void reportCommonSpan(CommonLogSpan commonLogSpan) {
        if (commonLogSpan == null) {
            return;
        }
        String logType = commonLogSpan.getLogType();
        if (StringUtils.isBlank(logType)) {
            SelfLog.error(LogCode2Description.convert((String)"sofa-tracer", (String)"01-00011"));
            return;
        }
        commonReporterAsyncManager.append(commonLogSpan);
    }

    public static void reportProfile(CommonLogSpan sofaTracerSpan) {
        if (sofaTracerSpan == null) {
            return;
        }
        sofaTracerSpan.setLogType(TracerSystemLogEnum.RPC_PROFILE.getDefaultLogName());
        commonReporterAsyncManager.append(sofaTracerSpan);
    }

    public static void reportError(CommonLogSpan sofaTracerSpan) {
        if (sofaTracerSpan == null) {
            return;
        }
        sofaTracerSpan.setLogType(TracerSystemLogEnum.MIDDLEWARE_ERROR.getDefaultLogName());
        commonReporterAsyncManager.append(sofaTracerSpan);
    }

    static {
        String logName = TracerSystemLogEnum.MIDDLEWARE_ERROR.getDefaultLogName();
        LoadTestAwareAppender traceAppender = LoadTestAwareAppender.createLoadTestAwareTimedRollingFileAppender(logName, SofaTracerConfiguration.getProperty(TracerSystemLogEnum.MIDDLEWARE_ERROR.getRollingKey()), SofaTracerConfiguration.getProperty(TracerSystemLogEnum.MIDDLEWARE_ERROR.getLogReverseKey()));
        commonReporterAsyncManager.addAppender(logName, traceAppender, commonSpanEncoder);
        String profileLogName = TracerSystemLogEnum.RPC_PROFILE.getDefaultLogName();
        LoadTestAwareAppender profileTraceAppender = LoadTestAwareAppender.createLoadTestAwareTimedRollingFileAppender(profileLogName, SofaTracerConfiguration.getProperty(TracerSystemLogEnum.RPC_PROFILE.getRollingKey()), SofaTracerConfiguration.getProperty(TracerSystemLogEnum.RPC_PROFILE.getLogReverseKey()));
        commonReporterAsyncManager.addAppender(profileLogName, profileTraceAppender, commonSpanEncoder);
        commonReporterAsyncManager.start("CommonProfileErrorAppender");
    }
}

