/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.common.tracer.core.reporter.stat;

import com.alipay.common.tracer.core.appender.TraceAppender;
import com.alipay.common.tracer.core.appender.builder.JsonStringBuilder;
import com.alipay.common.tracer.core.appender.builder.XStringBuilder;
import com.alipay.common.tracer.core.appender.file.LoadTestAwareAppender;
import com.alipay.common.tracer.core.appender.self.SelfLog;
import com.alipay.common.tracer.core.appender.self.Timestamp;
import com.alipay.common.tracer.core.configuration.SofaTracerConfiguration;
import com.alipay.common.tracer.core.reporter.stat.SofaTracerStatisticReporter;
import com.alipay.common.tracer.core.reporter.stat.manager.SofaTracerStatisticReporterCycleTimesManager;
import com.alipay.common.tracer.core.reporter.stat.model.StatKey;
import com.alipay.common.tracer.core.reporter.stat.model.StatMapKey;
import com.alipay.common.tracer.core.reporter.stat.model.StatValues;
import com.alipay.common.tracer.core.span.SofaTracerSpan;
import com.alipay.common.tracer.core.utils.AssertUtils;
import com.alipay.common.tracer.core.utils.StringUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;

public abstract class AbstractSofaTracerStatisticReporter
implements SofaTracerStatisticReporter {
    public static final int DEFAULT_CYCLE = 0;
    private static final ReentrantLock initLock = new ReentrantLock(false);
    private static XStringBuilder buffer = new XStringBuilder();
    private static JsonStringBuilder jsonBuffer = new JsonStringBuilder();
    protected AtomicBoolean isClosePrint = new AtomicBoolean(false);
    protected TraceAppender appender = null;
    protected String statTracerName;
    private long periodTime;
    private String rollingPolicy;
    private String logReserveConfig;
    private int printCycle = 0;
    private long countCycle = 0L;
    private Map<StatKey, StatValues>[] statDatasPair = new ConcurrentHashMap[2];
    private int currentIndex = 0;
    protected Map<StatKey, StatValues> statDatas;

    public AbstractSofaTracerStatisticReporter(String statTracerName, String rollingPolicy, String logReserveConfig) {
        this(statTracerName, 60L, 0, rollingPolicy, logReserveConfig);
    }

    public AbstractSofaTracerStatisticReporter(String statTracerName, long periodTime, int outputCycle, String rollingPolicy, String logReserveConfig) {
        AssertUtils.hasText(statTracerName, "Statistics tracer name cat't be empty.");
        this.statTracerName = statTracerName;
        this.periodTime = this.globalConfiguredCycleTime(periodTime);
        this.printCycle = outputCycle;
        this.rollingPolicy = rollingPolicy;
        this.logReserveConfig = logReserveConfig;
        for (int i = 0; i < 2; ++i) {
            this.statDatasPair[i] = new ConcurrentHashMap<StatKey, StatValues>(100);
        }
        this.statDatas = this.statDatasPair[this.currentIndex];
        SofaTracerStatisticReporterCycleTimesManager.registerStatReporter(this);
    }

    private long globalConfiguredCycleTime(long defaultCycle) {
        long cycleTime = defaultCycle;
        try {
            String statLogInterval = SofaTracerConfiguration.getProperty("stat_log_interval");
            if (StringUtils.isNotBlank(statLogInterval)) {
                cycleTime = Long.parseLong(statLogInterval);
            }
        }
        catch (Exception e) {
            SelfLog.error("Parse stat log interval configure error", e);
        }
        SelfLog.warn(this.getStatTracerName() + " configured " + "stat_log_interval" + "=" + cycleTime + " second and default cycle=" + defaultCycle);
        return cycleTime;
    }

    @Override
    public long getPeriodTime() {
        return this.periodTime;
    }

    @Override
    public String getStatTracerName() {
        return this.statTracerName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reportStat(SofaTracerSpan sofaTracerSpan) {
        if (sofaTracerSpan == null) {
            return;
        }
        if (this.appender == null) {
            AbstractSofaTracerStatisticReporter abstractSofaTracerStatisticReporter = this;
            synchronized (abstractSofaTracerStatisticReporter) {
                if (this.appender == null) {
                    this.appender = LoadTestAwareAppender.createLoadTestAwareTimedRollingFileAppender(this.statTracerName, this.rollingPolicy, this.logReserveConfig);
                }
            }
        }
        this.doReportStat(sofaTracerSpan);
    }

    public abstract void doReportStat(SofaTracerSpan var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addStat(StatKey keys, long ... values) {
        StatValues oldValues = this.statDatas.get(keys);
        if (oldValues == null) {
            initLock.lock();
            try {
                oldValues = this.statDatas.get(keys);
                if (null == oldValues) {
                    oldValues = new StatValues(values);
                    this.statDatas.put(keys, oldValues);
                    return;
                }
            }
            finally {
                initLock.unlock();
            }
        }
        if (oldValues != null) {
            oldValues.update(values);
        }
    }

    @Override
    public Map<StatKey, StatValues> shiftCurrentIndex() {
        Map<StatKey, StatValues> last = this.statDatasPair[this.currentIndex];
        this.currentIndex = 1 - this.currentIndex;
        this.statDatas = this.statDatasPair[this.currentIndex];
        return last;
    }

    public Map<StatKey, StatValues> getStatData() {
        return new HashMap<StatKey, StatValues>(this.statDatas);
    }

    public Map<StatKey, StatValues> getOtherStatData() {
        return new HashMap<StatKey, StatValues>(this.statDatasPair[1 - this.currentIndex]);
    }

    @Override
    public boolean shouldPrintNow() {
        return 0L == (this.countCycle >= (long)this.printCycle ? (this.countCycle = 0L) : (this.countCycle = this.countCycle + 1L));
    }

    @Override
    public void print(StatKey statKey, long[] values) {
        if (this.isClosePrint.get()) {
            return;
        }
        if ("false".equalsIgnoreCase(SofaTracerConfiguration.getProperty("global_json_format_output"))) {
            this.printXsbStat(statKey, values);
        } else {
            this.printJsbStat(statKey, values);
        }
    }

    protected void printXsbStat(StatKey statKey, long[] values) {
        try {
            int i;
            buffer.reset();
            buffer.append(Timestamp.currentTime()).append(statKey.getKey());
            for (i = 0; i < values.length - 1; ++i) {
                buffer.append(values[i]);
            }
            buffer.append(values[i]);
            buffer.append(statKey.getResult());
            buffer.appendEnd(statKey.getEnd());
            if (this.appender instanceof LoadTestAwareAppender) {
                ((LoadTestAwareAppender)this.appender).append(buffer.toString(), statKey.isLoadTest());
            } else {
                this.appender.append(buffer.toString());
            }
            this.appender.flush();
        }
        catch (Throwable t) {
            SelfLog.error("Stat log <" + this.statTracerName + "> output error!", t);
        }
    }

    protected void printJsbStat(StatKey statKey, long[] values) {
        if (!(statKey instanceof StatMapKey)) {
            return;
        }
        StatMapKey statMapKey = (StatMapKey)statKey;
        try {
            jsonBuffer.reset();
            jsonBuffer.appendBegin();
            jsonBuffer.append("time", Timestamp.currentTime());
            jsonBuffer.append("stat.key", this.statKeySplit(statMapKey));
            jsonBuffer.append("count", values[0]);
            jsonBuffer.append("total.cost.milliseconds", values[1]);
            jsonBuffer.append("success", statMapKey.getResult());
            jsonBuffer.appendEnd("load.test", statMapKey.getEnd());
            if (this.appender instanceof LoadTestAwareAppender) {
                ((LoadTestAwareAppender)this.appender).append(jsonBuffer.toString(), statMapKey.isLoadTest());
            } else {
                this.appender.append(jsonBuffer.toString());
            }
            this.appender.flush();
        }
        catch (Throwable t) {
            SelfLog.error("Stat log<" + this.statTracerName + "> error!", t);
        }
    }

    private String statKeySplit(StatMapKey statKey) {
        JsonStringBuilder jsonBufferKey = new JsonStringBuilder();
        Map<String, String> keyMap = statKey.getKeyMap();
        jsonBufferKey.appendBegin();
        for (Map.Entry<String, String> entry : keyMap.entrySet()) {
            jsonBufferKey.append(entry.getKey(), entry.getValue());
        }
        jsonBufferKey.appendEnd(false);
        return jsonBufferKey.toString();
    }

    @Override
    public void close() {
        this.isClosePrint.set(true);
    }

    public AtomicBoolean getIsClosePrint() {
        return this.isClosePrint;
    }

    public void setIsClosePrint(AtomicBoolean isClosePrint) {
        if (isClosePrint == null) {
            return;
        }
        this.isClosePrint.set(isClosePrint.get());
    }

    protected String buildString(String[] keys) {
        int i;
        XStringBuilder sb = new XStringBuilder();
        for (i = 0; i < keys.length - 1; ++i) {
            sb.append(keys[i] == null ? "" : keys[i]);
        }
        sb.appendRaw(keys[i] == null ? "" : keys[i]);
        return sb.toString();
    }

    protected boolean isHttpOrMvcSuccess(String resultCode) {
        return resultCode.charAt(0) == '1' || resultCode.charAt(0) == '2' || "302".equals(resultCode.trim()) || "301".equals(resultCode.trim());
    }

    protected boolean isWebHttpClientSuccess(String resultCode) {
        return StringUtils.isNotBlank(resultCode) && (this.isHttpOrMvcSuccess(resultCode) || "00".equals(resultCode));
    }

    protected boolean isMQSimpleSuccess(String resultCode) {
        return StringUtils.isNotBlank(resultCode) && "00".equals(resultCode);
    }
}

