/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.auth.signature.signer;

import com.aliyun.auth.signature.exception.SignatureException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;

public enum SignAlgorithmHmacSHA1 {
    HmacSHA1("HmacSHA1");

    private final ThreadLocal<Mac> reference;
    private final String algorithmName;

    private SignAlgorithmHmacSHA1(String algorithmName) {
        this.algorithmName = algorithmName;
        this.reference = new MacThreadLocal(algorithmName);
    }

    public String getAlgorithmName() {
        return this.algorithmName;
    }

    public Mac getMac() {
        return this.reference.get();
    }

    private static class MacThreadLocal
    extends ThreadLocal<Mac> {
        private final String algorithmName;

        MacThreadLocal(String algorithmName) {
            this.algorithmName = algorithmName;
        }

        @Override
        protected Mac initialValue() {
            try {
                return Mac.getInstance(this.algorithmName);
            }
            catch (NoSuchAlgorithmException e) {
                throw new SignatureException("Unable to fetch Mac instance for Algorithm " + this.algorithmName + e.getMessage());
            }
        }
    }
}

