/*
 * Decompiled with CFR 0.152.
 */
package com.aliyuncs.http;

import com.aliyuncs.http.FormatType;
import com.aliyuncs.http.MethodType;
import com.aliyuncs.utils.ParameterHelper;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class HttpRequest {
    private String url = null;
    private MethodType method = null;
    protected FormatType contentType = null;
    protected byte[] content = null;
    protected String encoding = null;
    protected Map<String, String> headers = null;

    public HttpRequest(String strUrl) {
        this.url = strUrl;
        this.headers = new HashMap<String, String>();
    }

    public HttpRequest(String strUrl, Map<String, String> tmpHeaders) {
        this.url = strUrl;
        if (null != tmpHeaders) {
            this.headers = tmpHeaders;
        }
    }

    public HttpRequest() {
    }

    public String getUrl() {
        return this.url;
    }

    protected void setUrl(String url) {
        this.url = url;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public FormatType getContentType() {
        return this.contentType;
    }

    public void setContentType(FormatType contentType) {
        this.contentType = contentType;
        if (null != this.content || null != contentType) {
            this.headers.put("Content-Type", this.getContentTypeValue(this.contentType, this.encoding));
        } else {
            this.headers.remove("Content-Type");
        }
    }

    public MethodType getMethod() {
        return this.method;
    }

    public void setMethod(MethodType method) {
        this.method = method;
    }

    public byte[] getContent() {
        return this.content;
    }

    public String getHeaderValue(String name) {
        return this.headers.get(name);
    }

    public void putHeaderParameter(String name, String value) {
        if (null != name && null != value) {
            this.headers.put(name, value);
        }
    }

    public void setContent(byte[] content, String encoding, FormatType format) throws NoSuchAlgorithmException {
        if (null == content) {
            this.headers.remove("Content-MD5");
            this.headers.remove("Content-Length");
            this.headers.remove("Content-Type");
            this.contentType = null;
            this.content = null;
            this.encoding = null;
            return;
        }
        this.content = content;
        this.encoding = encoding;
        String contentLen = String.valueOf(content.length);
        String strMd5 = ParameterHelper.md5Sum(content);
        this.contentType = null != format ? format : FormatType.RAW;
        this.headers.put("Content-MD5", strMd5);
        this.headers.put("Content-Length", contentLen);
        this.headers.put("Content-Type", this.getContentTypeValue(this.contentType, encoding));
    }

    public Map<String, String> getHeaders() {
        return Collections.unmodifiableMap(this.headers);
    }

    public HttpURLConnection getHttpConnection() throws IOException {
        Map<String, String> mappedHeaders = this.headers;
        String strUrl = this.url;
        if (null == strUrl || null == this.method) {
            return null;
        }
        URL url = null;
        String[] urlArray = null;
        if (MethodType.POST.equals((Object)this.method)) {
            urlArray = strUrl.split("\\?");
            url = new URL(urlArray[0]);
        } else {
            url = new URL(strUrl);
        }
        HttpURLConnection httpConn = (HttpURLConnection)url.openConnection();
        httpConn.setRequestMethod(this.method.toString());
        httpConn.setDoOutput(true);
        httpConn.setDoInput(true);
        httpConn.setUseCaches(false);
        for (Map.Entry<String, String> entry : mappedHeaders.entrySet()) {
            httpConn.setRequestProperty(entry.getKey(), entry.getValue());
        }
        if (null != this.getHeaderValue("Content-Type")) {
            httpConn.setRequestProperty("Content-Type", this.getHeaderValue("Content-Type"));
        } else {
            String contentTypeValue = this.getContentTypeValue(this.contentType, this.encoding);
            if (null != contentTypeValue) {
                httpConn.setRequestProperty("Content-Type", contentTypeValue);
            }
        }
        if (MethodType.POST.equals((Object)this.method) && urlArray.length == 2) {
            httpConn.getOutputStream().write(urlArray[1].getBytes());
        }
        return httpConn;
    }

    private String getContentTypeValue(FormatType contentType, String encoding) {
        if (null != contentType && null != encoding) {
            return FormatType.mapFormatToAccept(contentType) + ";charset=" + encoding.toLowerCase();
        }
        if (null != contentType) {
            return FormatType.mapFormatToAccept(contentType);
        }
        return null;
    }
}

