/*
 * Decompiled with CFR 0.152.
 */
package com.aliyuncs.profile;

import com.aliyuncs.auth.Credential;
import com.aliyuncs.auth.ICredentialProvider;
import com.aliyuncs.auth.ISigner;
import com.aliyuncs.auth.ShaHmac1;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.http.FormatType;
import com.aliyuncs.profile.IClientProfile;
import com.aliyuncs.regions.Endpoint;
import com.aliyuncs.regions.IEndpointsProvider;
import com.aliyuncs.regions.InternalEndpointsParser;
import com.aliyuncs.regions.ProductDomain;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DefaultProfile
implements IClientProfile {
    private static DefaultProfile profile = null;
    private static List<Endpoint> endpoints = null;
    private Credential credential = null;
    private String regionId = null;
    private FormatType acceptFormat = null;
    private ISigner isigner = null;
    private IEndpointsProvider iendpoints = null;
    private ICredentialProvider icredential = null;

    private DefaultProfile() {
        this.iendpoints = new InternalEndpointsParser();
    }

    private DefaultProfile(String region, Credential creden) {
        this.iendpoints = new InternalEndpointsParser();
        this.credential = creden;
        this.regionId = region;
    }

    private DefaultProfile(ICredentialProvider icredential) {
        this.icredential = icredential;
        this.iendpoints = new InternalEndpointsParser();
    }

    private DefaultProfile(String region, ICredentialProvider icredential) {
        this.regionId = region;
        this.icredential = icredential;
        this.iendpoints = new InternalEndpointsParser();
    }

    private DefaultProfile(ICredentialProvider icredential, String region, FormatType format) {
        this.regionId = region;
        this.acceptFormat = format;
        this.icredential = icredential;
        this.iendpoints = new InternalEndpointsParser();
    }

    @Override
    public synchronized ISigner getSigner() {
        if (null == this.isigner) {
            this.isigner = new ShaHmac1();
        }
        return this.isigner;
    }

    @Override
    public synchronized String getRegionId() {
        return this.regionId;
    }

    @Override
    public synchronized FormatType getFormat() {
        return this.acceptFormat;
    }

    @Override
    public synchronized Credential getCredential() {
        if (null == this.credential && null != this.icredential) {
            this.credential = this.icredential.fresh();
        }
        return this.credential;
    }

    @Override
    public synchronized List<Endpoint> getEndpoints() throws ClientException {
        if (null == endpoints) {
            endpoints = this.iendpoints.getEndpoints();
        }
        return endpoints;
    }

    public static synchronized DefaultProfile getProfile() {
        if (null == profile) {
            profile = new DefaultProfile();
        }
        return profile;
    }

    public static synchronized DefaultProfile getProfile(String regionId, ICredentialProvider icredential) {
        profile = new DefaultProfile(regionId, icredential);
        return profile;
    }

    public static synchronized DefaultProfile getProfile(String regionId, String accessKeyId, String secret) {
        Credential creden = new Credential(accessKeyId, secret);
        profile = new DefaultProfile(regionId, creden);
        return profile;
    }

    public static synchronized void addEndpoint(String endpointName, String regionId, String product, String domain) throws ClientException {
        Endpoint endpoint;
        if (null == endpoints) {
            endpoints = DefaultProfile.getProfile().getEndpoints();
        }
        if (null == (endpoint = DefaultProfile.findEndpointByRegionId(regionId))) {
            DefaultProfile.addEndpoint_(endpointName, regionId, product, domain);
        } else {
            DefaultProfile.updateEndpoint(regionId, product, domain, endpoint);
        }
    }

    private static void addEndpoint_(String endpointName, String regionId, String product, String domain) {
        HashSet<String> regions = new HashSet<String>();
        regions.add(regionId);
        ArrayList<ProductDomain> productDomains = new ArrayList<ProductDomain>();
        productDomains.add(new ProductDomain(product, domain));
        Endpoint endpoint = new Endpoint(endpointName, regions, productDomains);
        endpoints.add(endpoint);
    }

    private static void updateEndpoint(String regionId, String product, String domain, Endpoint endpoint) {
        Set<String> regionIds = endpoint.getRegionIds();
        regionIds.add(regionId);
        List<ProductDomain> productDomains = endpoint.getProductDomains();
        ProductDomain productDomain = DefaultProfile.findProductDomain(productDomains, product);
        if (null == productDomain) {
            productDomains.add(new ProductDomain(product, domain));
        } else {
            productDomain.setDomianName(domain);
        }
    }

    private static Endpoint findEndpointByRegionId(String regionId) {
        for (Endpoint endpoint : endpoints) {
            if (!endpoint.getRegionIds().contains(regionId)) continue;
            return endpoint;
        }
        return null;
    }

    private static ProductDomain findProductDomain(List<ProductDomain> productDomains, String product) {
        for (ProductDomain productDomain : productDomains) {
            if (!productDomain.getProductName().equals(product)) continue;
            return productDomain;
        }
        return null;
    }
}

