/*
 * Decompiled with CFR 0.152.
 */
package com.aliyuncs;

import com.aliyuncs.AcsError;
import com.aliyuncs.AcsRequest;
import com.aliyuncs.AcsResponse;
import com.aliyuncs.CommonRequest;
import com.aliyuncs.CommonResponse;
import com.aliyuncs.IAcsClient;
import com.aliyuncs.auth.AlibabaCloudCredentials;
import com.aliyuncs.auth.AlibabaCloudCredentialsProvider;
import com.aliyuncs.auth.Credential;
import com.aliyuncs.auth.LegacyCredentials;
import com.aliyuncs.auth.Signer;
import com.aliyuncs.auth.StaticCredentialsProvider;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.exceptions.ServerException;
import com.aliyuncs.http.FormatType;
import com.aliyuncs.http.HttpRequest;
import com.aliyuncs.http.HttpResponse;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import com.aliyuncs.reader.Reader;
import com.aliyuncs.reader.ReaderFactory;
import com.aliyuncs.regions.Endpoint;
import com.aliyuncs.regions.ProductDomain;
import com.aliyuncs.transform.UnmarshallerContext;
import com.aliyuncs.utils.HttpsUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.SocketTimeoutException;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocketFactory;

public class DefaultAcsClient
implements IAcsClient {
    private int maxRetryNumber = 3;
    private boolean autoRetry = true;
    private IClientProfile clientProfile = null;
    private AlibabaCloudCredentialsProvider credentialsProvider;
    private SSLSocketFactory sslSocketFactory = null;

    public DefaultAcsClient() {
        this.clientProfile = DefaultProfile.getProfile();
        this.initSslSocketFactory();
    }

    public DefaultAcsClient(IClientProfile profile) {
        this.clientProfile = profile;
        this.credentialsProvider = new StaticCredentialsProvider(profile);
        this.clientProfile.setCredentialsProvider(this.credentialsProvider);
        this.initSslSocketFactory();
    }

    public DefaultAcsClient(IClientProfile profile, AlibabaCloudCredentials credentials) {
        this.clientProfile = profile;
        this.credentialsProvider = new StaticCredentialsProvider(credentials);
        this.clientProfile.setCredentialsProvider(this.credentialsProvider);
        this.initSslSocketFactory();
    }

    public DefaultAcsClient(IClientProfile profile, AlibabaCloudCredentialsProvider credentialsProvider) {
        this.clientProfile = profile;
        this.credentialsProvider = credentialsProvider;
        this.clientProfile.setCredentialsProvider(this.credentialsProvider);
        this.initSslSocketFactory();
    }

    private void initSslSocketFactory() {
        try {
            this.sslSocketFactory = HttpsUtils.buildJavaSSLSocketFactory(this.clientProfile.getCertPath());
        }
        catch (SSLException e) {
            System.err.println("buildSSLSocketFactory failed" + e.toString());
        }
    }

    @Override
    public <T extends AcsResponse> HttpResponse doAction(AcsRequest<T> request) throws ClientException, ServerException {
        return this.doAction(request, this.autoRetry, this.maxRetryNumber, this.clientProfile);
    }

    @Override
    public <T extends AcsResponse> HttpResponse doAction(AcsRequest<T> request, boolean autoRetry, int maxRetryCounts) throws ClientException, ServerException {
        return this.doAction(request, autoRetry, maxRetryCounts, this.clientProfile);
    }

    @Override
    public <T extends AcsResponse> HttpResponse doAction(AcsRequest<T> request, IClientProfile profile) throws ClientException, ServerException {
        return this.doAction(request, this.autoRetry, this.maxRetryNumber, profile);
    }

    @Override
    public <T extends AcsResponse> HttpResponse doAction(AcsRequest<T> request, String regionId, Credential credential) throws ClientException, ServerException {
        boolean retry = this.autoRetry;
        int retryNumber = this.maxRetryNumber;
        Signer signer = Signer.getSigner(new LegacyCredentials(credential));
        FormatType format = null;
        List<Endpoint> endpoints = null;
        if (null == request.getRegionId()) {
            request.setRegionId(regionId);
        }
        if (null != this.clientProfile) {
            format = this.clientProfile.getFormat();
            try {
                endpoints = this.clientProfile.getEndpoints(request.getProduct(), request.getRegionId(), request.getLocationProduct(), request.getEndpointType());
            }
            catch (Throwable e) {
                endpoints = this.clientProfile.getEndpoints(request.getRegionId(), request.getProduct());
            }
        }
        return this.doAction(request, retry, retryNumber, request.getRegionId(), credential, signer, format, endpoints);
    }

    @Override
    public <T extends AcsResponse> T getAcsResponse(AcsRequest<T> request) throws ServerException, ClientException {
        HttpResponse baseResponse = this.doAction(request);
        return this.parseAcsResponse(request.getResponseClass(), baseResponse);
    }

    @Override
    public <T extends AcsResponse> T getAcsResponse(AcsRequest<T> request, boolean autoRetry, int maxRetryCounts) throws ServerException, ClientException {
        HttpResponse baseResponse = this.doAction(request, autoRetry, maxRetryCounts);
        return this.parseAcsResponse(request.getResponseClass(), baseResponse);
    }

    @Override
    public <T extends AcsResponse> T getAcsResponse(AcsRequest<T> request, IClientProfile profile) throws ServerException, ClientException {
        HttpResponse baseResponse = this.doAction(request, profile);
        return this.parseAcsResponse(request.getResponseClass(), baseResponse);
    }

    @Override
    public <T extends AcsResponse> T getAcsResponse(AcsRequest<T> request, String regionId, Credential credential) throws ServerException, ClientException {
        HttpResponse baseResponse = this.doAction(request, regionId, credential);
        return this.parseAcsResponse(request.getResponseClass(), baseResponse);
    }

    @Override
    public CommonResponse getCommonResponse(CommonRequest request) throws ServerException, ClientException {
        HttpResponse baseResponse = this.doAction(request.buildRequest());
        String stringContent = this.getResponseContent(baseResponse);
        CommonResponse response = new CommonResponse();
        response.setData(stringContent);
        response.setHttpStatus(baseResponse.getStatus());
        response.setHttpResponse(baseResponse);
        return response;
    }

    @Override
    public <T extends AcsResponse> HttpResponse doAction(AcsRequest<T> request, boolean autoRetry, int maxRetryCounts, IClientProfile profile) throws ClientException, ServerException {
        List<Endpoint> endpoints;
        if (null == profile) {
            throw new ClientException("SDK.InvalidProfile", "No active profile found.");
        }
        boolean retry = autoRetry;
        int retryNumber = maxRetryCounts;
        String region = profile.getRegionId();
        if (null == request.getRegionId()) {
            request.setRegionId(region);
        }
        AlibabaCloudCredentials credentials = this.credentialsProvider.getCredentials();
        Signer signer = Signer.getSigner(credentials);
        FormatType format = profile.getFormat();
        try {
            endpoints = this.getEndpoints(request);
        }
        catch (Throwable e) {
            endpoints = this.clientProfile.getEndpoints(request.getRegionId(), request.getProduct());
        }
        return this.doAction(request, retry, retryNumber, request.getRegionId(), credentials, signer, format, endpoints);
    }

    private <T extends AcsResponse> T parseAcsResponse(Class<T> clasz, HttpResponse baseResponse) throws ServerException, ClientException {
        FormatType format = baseResponse.getHttpContentType();
        if (baseResponse.isSuccess()) {
            return this.readResponse(clasz, baseResponse, format);
        }
        AcsError error = this.readError(baseResponse, format);
        if (500 <= baseResponse.getStatus()) {
            throw new ServerException(error.getErrorCode(), error.getErrorMessage(), error.getRequestId());
        }
        throw new ClientException(error.getErrorCode(), error.getErrorMessage(), error.getRequestId());
    }

    @Override
    @Deprecated
    public <T extends AcsResponse> HttpResponse doAction(AcsRequest<T> request, boolean autoRetry, int maxRetryNumber, String regionId, Credential credential, Signer signer, FormatType format, List<Endpoint> endpoints) throws ClientException, ServerException {
        return this.doAction(request, autoRetry, maxRetryNumber, regionId, new LegacyCredentials(credential), signer, format, endpoints);
    }

    private <T extends AcsResponse> HttpResponse doAction(AcsRequest<T> request, boolean autoRetry, int maxRetryNumber, String regionId, AlibabaCloudCredentials credentials, Signer signer, FormatType format, List<Endpoint> endpoints) throws ClientException, ServerException {
        try {
            FormatType requestFormatType = request.getAcceptFormat();
            if (null != requestFormatType) {
                format = requestFormatType;
            }
            ProductDomain domain = null;
            domain = request.getProductDomain() != null ? request.getProductDomain() : Endpoint.findProductDomain(regionId, request.getProduct(), endpoints);
            if (null == domain) {
                throw new ClientException("SDK.InvalidRegionId", "Can not find endpoint to access.");
            }
            boolean shouldRetry = true;
            int retryTimes = 0;
            while (shouldRetry) {
                shouldRetry = autoRetry && retryTimes < maxRetryNumber;
                HttpRequest httpRequest = request.signRequest(signer, credentials, format, domain);
                httpRequest.setSslSocketFactory(this.sslSocketFactory);
                HttpResponse response = HttpResponse.getResponse(httpRequest);
                if (response.getHttpContent() == null) {
                    if (!shouldRetry) {
                        throw new ClientException("SDK.ConnectionReset", "Connection reset.");
                    }
                } else if (500 > response.getStatus() || !shouldRetry) {
                    return response;
                }
                ++retryTimes;
            }
        }
        catch (InvalidKeyException exp) {
            throw new ClientException("SDK.InvalidAccessSecret", "Speicified access secret is not valid.");
        }
        catch (SocketTimeoutException exp) {
            throw new ClientException("SDK.ServerUnreachable", "SocketTimeoutException has occurred on a socket read or accept.");
        }
        catch (IOException exp) {
            throw new ClientException("SDK.ServerUnreachable", "Server unreachable: " + exp.toString());
        }
        catch (NoSuchAlgorithmException exp) {
            throw new ClientException("SDK.InvalidMD5Algorithm", "MD5 hash is not supported by client side.");
        }
        catch (GeneralSecurityException exp) {
            throw new ClientException("SDK.SecureConnectorError", "Send request with specific SecureConnector failed: " + exp.toString());
        }
        return null;
    }

    private <T extends AcsResponse> T readResponse(Class<T> clasz, HttpResponse httpResponse, FormatType format) throws ClientException {
        Reader reader = ReaderFactory.createInstance(format);
        UnmarshallerContext context = new UnmarshallerContext();
        AcsResponse response = null;
        String stringContent = this.getResponseContent(httpResponse);
        try {
            response = (AcsResponse)clasz.newInstance();
        }
        catch (Exception e) {
            throw new ClientException("SDK.InvalidResponseClass", "Unable to allocate " + clasz.getName() + " class");
        }
        String responseEndpoint = clasz.getName().substring(clasz.getName().lastIndexOf(".") + 1);
        if (response.checkShowJsonItemName()) {
            context.setResponseMap(reader.read(stringContent, responseEndpoint));
        } else {
            context.setResponseMap(reader.readForHideArrayItem(stringContent, responseEndpoint));
        }
        context.setHttpResponse(httpResponse);
        response.getInstance(context);
        return (T)response;
    }

    private String getResponseContent(HttpResponse httpResponse) throws ClientException {
        String stringContent = null;
        try {
            stringContent = null == httpResponse.getEncoding() ? new String(httpResponse.getHttpContent()) : new String(httpResponse.getHttpContent(), httpResponse.getEncoding());
        }
        catch (UnsupportedEncodingException exp) {
            throw new ClientException("SDK.UnsupportedEncoding", "Can not parse response due to un supported encoding.");
        }
        return stringContent;
    }

    private AcsError readError(HttpResponse httpResponse, FormatType format) throws ClientException {
        AcsError error = new AcsError();
        String responseEndpoint = "Error";
        Reader reader = ReaderFactory.createInstance(format);
        UnmarshallerContext context = new UnmarshallerContext();
        String stringContent = this.getResponseContent(httpResponse);
        context.setResponseMap(reader.read(stringContent, responseEndpoint));
        return error.getInstance(context);
    }

    private List<Endpoint> getEndpoints(AcsRequest request) throws ClientException {
        if (request.getProductDomain() != null && request.getProductDomain().getDomianName() != null) {
            return new ArrayList<Endpoint>();
        }
        return this.clientProfile.getEndpoints(request.getProduct(), request.getRegionId(), request.getLocationProduct(), request.getEndpointType());
    }

    public boolean isAutoRetry() {
        return this.autoRetry;
    }

    public void setAutoRetry(boolean autoRetry) {
        this.autoRetry = autoRetry;
    }

    public int getMaxRetryNumber() {
        return this.maxRetryNumber;
    }

    public void setMaxRetryNumber(int maxRetryNumber) {
        this.maxRetryNumber = maxRetryNumber;
    }
}

