/*
 * Decompiled with CFR 0.152.
 */
package com.aliyuncs.auth;

import com.aliyuncs.auth.AlibabaCloudCredentials;

public class BasicSessionCredentials
implements AlibabaCloudCredentials {
    protected final long roleSessionDurationSeconds;
    private final String accessKeyId;
    private final String accessKeySecret;
    private final String sessionToken;
    private final double expireFact = 0.8;
    private long sessionStartedTimeInMilliSeconds = 0L;

    public BasicSessionCredentials(String accessKeyId, String accessKeySecret, String sessionToken) {
        this(accessKeyId, accessKeySecret, sessionToken, 0L);
    }

    public BasicSessionCredentials(String accessKeyId, String accessKeySecret, String sessionToken, long roleSessionDurationSeconds) {
        if (accessKeyId == null) {
            throw new IllegalArgumentException("Access key ID cannot be null.");
        }
        if (accessKeySecret == null) {
            throw new IllegalArgumentException("Access key secret cannot be null.");
        }
        this.accessKeyId = accessKeyId;
        this.accessKeySecret = accessKeySecret;
        this.sessionToken = sessionToken;
        this.roleSessionDurationSeconds = roleSessionDurationSeconds;
        this.sessionStartedTimeInMilliSeconds = System.currentTimeMillis();
    }

    @Override
    public String getAccessKeyId() {
        return this.accessKeyId;
    }

    @Override
    public String getAccessKeySecret() {
        return this.accessKeySecret;
    }

    public String getSessionToken() {
        return this.sessionToken;
    }

    public boolean willSoonExpire() {
        if (this.roleSessionDurationSeconds == 0L) {
            return false;
        }
        long now = System.currentTimeMillis();
        return (double)this.roleSessionDurationSeconds * 0.8 < (double)(now - this.sessionStartedTimeInMilliSeconds) / 1000.0;
    }
}

