/*
 * Decompiled with CFR 0.152.
 */
package com.aliyuncs.auth.signers;

import com.aliyuncs.auth.AcsURLEncoder;
import com.aliyuncs.auth.AlibabaCloudCredentials;
import com.aliyuncs.auth.Signer;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class HmacSHA256Signer
extends Signer {
    private static final String ALGORITHM_NAME = "HmacSHA256";
    private static String HASH_SHA256 = "SHA-256";

    @Override
    public String signString(String stringToSign, String accessKeySecret) {
        try {
            Mac sha256_HMAC = Mac.getInstance(ALGORITHM_NAME);
            SecretKeySpec secret_key = new SecretKeySpec(accessKeySecret.getBytes(), ALGORITHM_NAME);
            sha256_HMAC.init(secret_key);
            return AcsURLEncoder.hexEncode(sha256_HMAC.doFinal(stringToSign.getBytes()));
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(e.toString());
        }
        catch (InvalidKeyException e) {
            throw new IllegalArgumentException(e.toString());
        }
    }

    @Override
    public String signString(String stringToSign, AlibabaCloudCredentials credentials) {
        return this.signString(stringToSign, credentials.getAccessKeySecret());
    }

    @Override
    public String getSignerName() {
        return ALGORITHM_NAME;
    }

    @Override
    public String getSignerVersion() {
        return "3.0";
    }

    @Override
    public String getSignerType() {
        return null;
    }

    @Override
    public byte[] hash(byte[] raw) throws NoSuchAlgorithmException {
        if (null == raw) {
            return null;
        }
        MessageDigest digest = MessageDigest.getInstance(HASH_SHA256);
        return digest.digest(raw);
    }

    @Override
    public String getContent() {
        return "x-acs-content-sha256";
    }
}

