/*
 * Decompiled with CFR 0.152.
 */
package com.aliyuncs.policy.retry;

import com.aliyuncs.exceptions.ThrottlingException;
import com.aliyuncs.policy.cache.ThrottlingPool;
import com.aliyuncs.policy.retry.RetryPolicyContext;
import com.aliyuncs.policy.retry.RetryUtil;
import com.aliyuncs.policy.retry.backoff.BackoffStrategy;
import com.aliyuncs.policy.retry.backoff.EqualJitterBackoffStrategy;
import com.aliyuncs.policy.retry.conditions.ExceptionsCondition;
import com.aliyuncs.policy.retry.conditions.HeadersCondition;
import com.aliyuncs.policy.retry.conditions.RetryCondition;
import com.aliyuncs.policy.retry.conditions.StatusCodeCondition;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;

public final class RetryPolicy {
    private final int maxNumberOfRetries;
    private final int maxDelayTimeMillis;
    private final BackoffStrategy backoffStrategy;
    private final Set<RetryCondition> retryConditions;
    private final Set<RetryCondition> throttlingConditions;
    private final Boolean enableAliyunThrottlingControl;

    private RetryPolicy(BuilderImpl builder) {
        this.maxNumberOfRetries = builder.maxNumberOfRetries;
        this.maxDelayTimeMillis = builder.maxDelayTimeMillis;
        this.backoffStrategy = builder.backoffStrategy;
        this.retryConditions = builder.retryConditions;
        this.throttlingConditions = builder.throttlingConditions;
        this.enableAliyunThrottlingControl = builder.enableAliyunThrottlingControl;
    }

    public static RetryPolicy defaultRetryPolicy(Boolean enableAliyunThrottlingControl) {
        return RetryPolicy.builder().enableAliyunThrottlingControl(enableAliyunThrottlingControl).build();
    }

    public static RetryPolicy none() {
        return RetryPolicy.builder().maxNumberOfRetries(0).build();
    }

    public Boolean shouldRetry(RetryPolicyContext context) {
        if (context.retriesAttempted() > this.maxNumberOfRetries) {
            return false;
        }
        if (this.throttlingConditions != null && !this.throttlingConditions.isEmpty()) {
            for (RetryCondition throttlingCondition : this.throttlingConditions) {
                if (!throttlingCondition.meetState(context)) continue;
                if (throttlingCondition.escapeTime(context) <= -1) {
                    return false;
                }
                if (!this.enableAliyunThrottlingControl.booleanValue()) continue;
                long current = System.currentTimeMillis();
                int escapeTime = throttlingCondition.escapeTime(context);
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
                String endTime = df.format(new Date(current + (long)escapeTime));
                ThrottlingPool.put(context.coordinate(), endTime, escapeTime);
                if (context.exception() != null && ThrottlingException.class.isAssignableFrom(context.exception().getClass())) continue;
                context.updateException(new ThrottlingException("SDK.TriggerThrottlingPolicy", "Client triggered throttling policy, server cannot be accessed before " + endTime + (context.exception() != null ? ". Error message: \n" + context.exception().getMessage() : "."), context.exception()));
            }
        }
        if (this.getBackoffDelay(context) > this.maxDelayTimeMillis) {
            return false;
        }
        if (this.retryConditions != null && !this.retryConditions.isEmpty()) {
            for (RetryCondition retryCondition : this.retryConditions) {
                if (!retryCondition.meetState(context)) continue;
                return true;
            }
        }
        return context.retriesAttempted() == 0;
    }

    public int getBackoffDelay(RetryPolicyContext context) {
        if (context.retriesAttempted() == 0) {
            if (ThrottlingPool.get(context.coordinate()) != null) {
                long current = System.currentTimeMillis();
                int escapeTime = ThrottlingPool.getExpire(context.coordinate());
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
                String endTime = df.format(new Date(current + (long)escapeTime));
                if (context.exception() == null || !ThrottlingException.class.isAssignableFrom(context.exception().getClass())) {
                    context.updateException(new ThrottlingException("SDK.TriggerThrottlingPolicy", "Client triggered throttling policy, server cannot be accessed before " + endTime + (context.exception() != null ? ". Error message: \n" + context.exception().getMessage() : "."), context.exception()));
                }
                return escapeTime;
            }
            return -1;
        }
        int delayTimeMillis = this.backoffStrategy.computeDelayBeforeNextRetry(context);
        if (this.throttlingConditions != null && !this.throttlingConditions.isEmpty()) {
            for (RetryCondition throttlingCondition : this.throttlingConditions) {
                if (!throttlingCondition.meetState(context)) continue;
                delayTimeMillis = Math.max(delayTimeMillis, throttlingCondition.escapeTime(context));
            }
        }
        return delayTimeMillis;
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public int maxNumberOfRetries() {
        return this.maxNumberOfRetries;
    }

    public int maxDelayTimeMillis() {
        return this.maxDelayTimeMillis;
    }

    public BackoffStrategy backoffStrategy() {
        return this.backoffStrategy;
    }

    public Set<RetryCondition> retryConditions() {
        return this.retryConditions;
    }

    public Set<RetryCondition> throttlingConditions() {
        return this.throttlingConditions;
    }

    public Boolean enableAliyunThrottlingControl() {
        return this.enableAliyunThrottlingControl;
    }

    public Builder toBuilder() {
        return RetryPolicy.builder().maxNumberOfRetries(this.maxNumberOfRetries).maxDelayTimeMillis(this.maxDelayTimeMillis).backoffStrategy(this.backoffStrategy).retryConditions(this.retryConditions).throttlingConditions(this.throttlingConditions).enableAliyunThrottlingControl(this.enableAliyunThrottlingControl);
    }

    public static final class BuilderImpl
    implements Builder {
        private int maxNumberOfRetries = 3;
        private int maxDelayTimeMillis = 120000;
        private BackoffStrategy backoffStrategy;
        private Set<RetryCondition> retryConditions = new HashSet<RetryCondition>();
        private Set<RetryCondition> throttlingConditions = new HashSet<RetryCondition>();
        private Boolean enableAliyunThrottlingControl = false;
        private static RetryCondition aliyunThrottlingCondition = HeadersCondition.create(RetryUtil.THROTTLING_PATTERNS);

        private BuilderImpl() {
            this.backoffStrategy = new EqualJitterBackoffStrategy(100, this.maxDelayTimeMillis, new Random());
            this.retryConditions.add(ExceptionsCondition.create(RetryUtil.RETRYABLE_EXCEPTIONS));
            this.retryConditions.add(StatusCodeCondition.create(RetryUtil.RETRYABLE_STATUS_CODES));
        }

        @Override
        public Builder maxNumberOfRetries(int maxNumberOfRetries) {
            this.maxNumberOfRetries = maxNumberOfRetries;
            return this;
        }

        @Override
        public Builder maxDelayTimeMillis(int maxDelayTimeMillis) {
            this.maxDelayTimeMillis = maxDelayTimeMillis;
            return this;
        }

        @Override
        public Builder backoffStrategy(BackoffStrategy backoffStrategy) {
            this.backoffStrategy = backoffStrategy;
            return this;
        }

        @Override
        public Builder retryConditions(Set<RetryCondition> retryConditions) {
            this.retryConditions = retryConditions;
            return this;
        }

        public Builder retryConditions(RetryCondition ... retryCondition) {
            this.retryConditions = new HashSet<RetryCondition>(Arrays.asList(retryCondition));
            return this;
        }

        @Override
        public Builder throttlingConditions(Set<RetryCondition> throttlingConditions) {
            this.throttlingConditions = throttlingConditions;
            return this;
        }

        public Builder throttlingConditions(RetryCondition ... throttlingCondition) {
            this.throttlingConditions = new HashSet<RetryCondition>(Arrays.asList(throttlingCondition));
            return this;
        }

        @Override
        public Builder enableAliyunThrottlingControl(Boolean enableAliyunThrottlingControl) {
            this.enableAliyunThrottlingControl = enableAliyunThrottlingControl;
            if (this.enableAliyunThrottlingControl.booleanValue()) {
                if (!this.throttlingConditions.contains(aliyunThrottlingCondition)) {
                    this.throttlingConditions.add(aliyunThrottlingCondition);
                }
            } else if (this.throttlingConditions.contains(aliyunThrottlingCondition)) {
                this.throttlingConditions.remove(aliyunThrottlingCondition);
            }
            return this;
        }

        @Override
        public RetryPolicy build() {
            return new RetryPolicy(this);
        }
    }

    public static interface Builder {
        public Builder maxNumberOfRetries(int var1);

        public Builder maxDelayTimeMillis(int var1);

        public Builder backoffStrategy(BackoffStrategy var1);

        public Builder retryConditions(Set<RetryCondition> var1);

        public Builder throttlingConditions(Set<RetryCondition> var1);

        public Builder enableAliyunThrottlingControl(Boolean var1);

        public RetryPolicy build();
    }
}

