/*
 * Decompiled with CFR 0.152.
 */
package darabonba.core.client;

import com.aliyun.auth.credentials.provider.ICredentialProvider;
import darabonba.core.client.ClientConfiguration;
import darabonba.core.client.ClientOption;
import darabonba.core.client.ClientOverrideConfiguration;
import darabonba.core.client.IClientBuilder;

public abstract class DefaultClientBuilder<B extends IClientBuilder<B, C>, C>
implements IClientBuilder<B, C> {
    protected ClientConfiguration clientConfiguration = ClientConfiguration.create();

    protected DefaultClientBuilder() {
    }

    @Override
    public final C build() {
        return this.buildClient();
    }

    @Override
    public B credentialsProvider(ICredentialProvider credentialsProvider) {
        this.clientConfiguration.setOption(ClientOption.CREDENTIALS_PROVIDER, credentialsProvider);
        return (B)this;
    }

    @Override
    public B region(String region) {
        this.clientConfiguration.setOption(ClientOption.REGION, region);
        return (B)this;
    }

    @Override
    public B overrideConfiguration(ClientOverrideConfiguration overrideConfiguration) {
        this.clientConfiguration = this.clientConfiguration.merge(ClientConfiguration.create().setOption(ClientOption.ENDPOINT_TYPE, overrideConfiguration.endpointType()).setOption(ClientOption.ENDPOINT, overrideConfiguration.endpointOverride()).setOption(ClientOption.CONNECT_TIMEOUT, overrideConfiguration.connectTimeout()).setOption(ClientOption.RESPONSE_TIMEOUT, overrideConfiguration.responseTimeout()).setOption(ClientOption.RETRY_POLICY, overrideConfiguration.retryPolicy()).setOption(ClientOption.HTTP_PROTOCOL, overrideConfiguration.protocol()).setOption(ClientOption.ADDITIONAL_HTTP_HEADERS, overrideConfiguration.httpHeaders()).setOption(ClientOption.USER_AGENT_USER_SUFFIX, overrideConfiguration.additionalUserAgent()));
        return (B)this;
    }

    protected abstract C buildClient();

    protected final ClientConfiguration applyClientConfiguration() {
        ClientConfiguration configuration = this.clientConfiguration;
        configuration = this.mergeChildDefaults(configuration);
        configuration = this.mergeGlobalDefaults(configuration);
        configuration = this.finalizeChildConfiguration(configuration);
        configuration = this.finalizeConfiguration(configuration);
        return configuration;
    }

    protected ClientConfiguration mergeChildDefaults(ClientConfiguration configuration) {
        return configuration;
    }

    private ClientConfiguration mergeGlobalDefaults(ClientConfiguration configuration) {
        return configuration;
    }

    protected ClientConfiguration finalizeChildConfiguration(ClientConfiguration configuration) {
        return configuration;
    }

    private ClientConfiguration finalizeConfiguration(ClientConfiguration configuration) {
        return configuration;
    }
}

