/*
 * Decompiled with CFR 0.152.
 */
package darabonba.core.policy.retry;

import com.aliyun.core.logging.ClientLogger;
import darabonba.core.policy.retry.RetryUtil;
import darabonba.core.policy.retry.backoff.BackoffStrategy;
import darabonba.core.policy.retry.conditions.AndRetryCondition;
import darabonba.core.policy.retry.conditions.MaxRetriesCondition;
import darabonba.core.policy.retry.conditions.RetryCondition;

public final class RetryPolicy {
    private final ClientLogger logger = new ClientLogger(RetryPolicy.class);
    private final BackoffStrategy backoffStrategy;
    private final Integer numRetries;
    private final RetryCondition retryCondition;
    private final RetryCondition aggregateRetryCondition;

    private RetryPolicy(BuilderImpl builder) {
        this.backoffStrategy = builder.backoffStrategy;
        this.numRetries = builder.numRetries;
        this.retryCondition = builder.retryCondition;
        this.aggregateRetryCondition = this.generateAggregateRetryCondition();
    }

    public static RetryPolicy defaultRetryPolicy() {
        return RetryPolicy.builder().build();
    }

    public static RetryPolicy none() {
        return RetryPolicy.builder().numRetries(0).backoffStrategy(BackoffStrategy.none()).retryCondition(RetryCondition.none()).build();
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public RetryCondition aggregateRetryCondition() {
        return this.aggregateRetryCondition;
    }

    public RetryCondition retryCondition() {
        return this.retryCondition;
    }

    public BackoffStrategy backoffStrategy() {
        return this.backoffStrategy;
    }

    public Integer numRetries() {
        return this.numRetries;
    }

    private RetryCondition generateAggregateRetryCondition() {
        AndRetryCondition aggregate = AndRetryCondition.create(MaxRetriesCondition.create(this.numRetries), this.retryCondition);
        return aggregate;
    }

    public Builder toBuilder() {
        return RetryPolicy.builder().numRetries(this.numRetries).retryCondition(this.retryCondition).backoffStrategy(this.backoffStrategy);
    }

    public static final class BuilderImpl
    implements Builder {
        private Integer numRetries = RetryUtil.DEFAULT_MAX_RETRIES;
        private BackoffStrategy backoffStrategy = BackoffStrategy.defaultStrategy();
        private BackoffStrategy throttlingBackoffStrategy = BackoffStrategy.defaultThrottlingStrategy();
        private RetryCondition retryCondition = RetryCondition.defaultRetryCondition();

        private BuilderImpl() {
        }

        @Override
        public Builder numRetries(Integer numRetries) {
            this.numRetries = numRetries;
            return this;
        }

        @Override
        public Builder backoffStrategy(BackoffStrategy backoffStrategy) {
            this.backoffStrategy = backoffStrategy;
            return this;
        }

        @Override
        public Builder retryCondition(RetryCondition retryCondition) {
            this.retryCondition = retryCondition;
            return this;
        }

        @Override
        public RetryPolicy build() {
            return new RetryPolicy(this);
        }
    }

    public static interface Builder {
        public Builder backoffStrategy(BackoffStrategy var1);

        public Builder retryCondition(RetryCondition var1);

        public Builder numRetries(Integer var1);

        public RetryPolicy build();
    }
}

