/*
 * Decompiled with CFR 0.152.
 */
package darabonba.core;

import com.aliyun.core.annotation.EnumType;
import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.ParentIgnore;
import com.aliyun.core.annotation.Validation;
import com.aliyun.core.logging.ClientLogger;
import darabonba.core.exception.TeaException;
import darabonba.core.exception.ValidateException;
import darabonba.core.utils.CommonUtil;
import darabonba.core.utils.ModelUtil;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class TeaModel {
    private static final ClientLogger logger = new ClientLogger(TeaModel.class);

    public Map<String, Object> toMap() {
        return TeaModel.changeToMap(this, true);
    }

    public static Map<String, Object> toMap(Object object) {
        return TeaModel.toMap(object, true);
    }

    public static Map<String, Object> toMap(Object object, boolean exceptStream) {
        Map<String, Object> map = new HashMap<String, Object>();
        if (object instanceof Map) {
            return (Map)object;
        }
        if (null == object || !TeaModel.class.isAssignableFrom(object.getClass())) {
            return map;
        }
        map = TeaModel.changeToMap(object, exceptStream);
        return map;
    }

    public Map<String, Object> toMap(boolean exceptStream) {
        return TeaModel.changeToMap(this, exceptStream);
    }

    private static Map<String, Object> changeToMap(Object object, boolean exceptStream) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            for (Field field : object.getClass().getDeclaredFields()) {
                field.setAccessible(true);
                NameInMap anno = field.getAnnotation(NameInMap.class);
                String key = anno == null ? field.getName() : anno.value();
                if (null != field.get(object) && List.class.isAssignableFrom(field.get(object).getClass())) {
                    List arrayField = (List)field.get(object);
                    ArrayList<Object> fieldList = new ArrayList<Object>();
                    for (int i = 0; i < arrayField.size(); ++i) {
                        fieldList.add(ModelUtil.parseObject(arrayField.get(i)));
                    }
                    map.put(key, fieldList);
                    continue;
                }
                if (null != field.get(object) && TeaModel.class.isAssignableFrom(field.get(object).getClass())) {
                    map.put(key, TeaModel.toMap(field.get(object), exceptStream));
                    continue;
                }
                if (null != field.get(object) && field.get(object).getClass().getDeclaredAnnotation(EnumType.class) != null) {
                    Method method = field.get(object).getClass().getDeclaredMethod("getValue", new Class[0]);
                    map.put(key, method.invoke(field.get(object), new Object[0]));
                    continue;
                }
                if (null != field.get(object) && Map.class.isAssignableFrom(field.get(object).getClass())) {
                    Map valueMap = (Map)field.get(object);
                    HashMap result = new HashMap();
                    for (Map.Entry entry : valueMap.entrySet()) {
                        result.put(entry.getKey(), ModelUtil.parseObject(entry.getValue()));
                    }
                    map.put(key, result);
                    continue;
                }
                if (exceptStream && null != field.get(object) && InputStream.class.isAssignableFrom(field.get(object).getClass()) || exceptStream && null != field.get(object) && OutputStream.class.isAssignableFrom(field.get(object).getClass())) continue;
                map.put(key, field.get(object));
            }
        }
        catch (Exception e) {
            throw new TeaException(e.getMessage(), e);
        }
        return map;
    }

    private static Object buildObject(Object o, Class self, Type subType) {
        Class<?> valueClass = o.getClass();
        if (Map.class.isAssignableFrom(self) && Map.class.isAssignableFrom(valueClass)) {
            Map valueMap = (Map)o;
            HashMap result = new HashMap();
            for (Map.Entry entry : valueMap.entrySet()) {
                if (null == subType || subType instanceof WildcardType) {
                    result.put(entry.getKey(), entry.getValue());
                    continue;
                }
                if (subType instanceof Class) {
                    result.put(entry.getKey(), TeaModel.buildObject(entry.getValue(), (Class)subType, null));
                    continue;
                }
                ParameterizedType parameterizedType = (ParameterizedType)subType;
                Type[] types = parameterizedType.getActualTypeArguments();
                result.put(entry.getKey(), TeaModel.buildObject(entry.getValue(), (Class)parameterizedType.getRawType(), types[types.length - 1]));
            }
            return result;
        }
        if (List.class.isAssignableFrom(self) && List.class.isAssignableFrom(valueClass)) {
            List valueList = (List)o;
            ArrayList<Object> result = new ArrayList<Object>();
            for (Object object : valueList) {
                if (null == subType || subType instanceof WildcardType) {
                    result.add(object);
                    continue;
                }
                if (subType instanceof Class) {
                    result.add(TeaModel.buildObject(object, (Class)subType, null));
                    continue;
                }
                ParameterizedType parameterizedType = (ParameterizedType)subType;
                Type[] types = parameterizedType.getActualTypeArguments();
                result.add(TeaModel.buildObject(object, (Class)parameterizedType.getRawType(), types[types.length - 1]));
            }
            return result;
        }
        if (TeaModel.class.isAssignableFrom(self) && Map.class.isAssignableFrom(valueClass)) {
            try {
                Method method = self.getMethod("create", new Class[0]);
                Object data = method.invoke(null, new Object[0]);
                return TeaModel.toModel((Map)o, (TeaModel)data);
            }
            catch (Exception e) {
                throw new TeaException(e.getMessage(), e);
            }
        }
        return TeaModel.confirmType(self, o);
    }

    private static Object buildPrefixObject(Object o, Class self, Type subType) {
        Class<?> valueClass = o.getClass();
        if (Map.class.isAssignableFrom(self) && Map.class.isAssignableFrom(valueClass)) {
            Map valueMap = (Map)o;
            HashMap result = new HashMap();
            for (Map.Entry entry : valueMap.entrySet()) {
                if (null == subType || subType instanceof WildcardType) {
                    result.put(entry.getKey(), entry.getValue());
                    continue;
                }
                if (subType instanceof Class) {
                    result.put(entry.getKey(), TeaModel.buildPrefixObject(entry.getValue(), (Class)subType, null));
                    continue;
                }
                ParameterizedType parameterizedType = (ParameterizedType)subType;
                Type[] types = parameterizedType.getActualTypeArguments();
                result.put(entry.getKey(), TeaModel.buildPrefixObject(entry.getValue(), (Class)parameterizedType.getRawType(), types[types.length - 1]));
            }
            return result;
        }
        if (List.class.isAssignableFrom(self)) {
            List valueList = new ArrayList<Object>();
            if (List.class.isAssignableFrom(valueClass)) {
                valueList = (List)o;
            } else {
                valueList.add(o);
            }
            ArrayList<Object> result = new ArrayList<Object>();
            for (Object object : valueList) {
                if (null == subType || subType instanceof WildcardType) {
                    result.add(object);
                    continue;
                }
                if (subType instanceof Class) {
                    result.add(TeaModel.buildPrefixObject(object, (Class)subType, null));
                    continue;
                }
                ParameterizedType parameterizedType = (ParameterizedType)subType;
                Type[] types = parameterizedType.getActualTypeArguments();
                result.add(TeaModel.buildPrefixObject(object, (Class)parameterizedType.getRawType(), types[types.length - 1]));
            }
            return result;
        }
        if (TeaModel.class.isAssignableFrom(self) && Map.class.isAssignableFrom(valueClass)) {
            try {
                Method method = self.getMethod("create", new Class[0]);
                Object data = method.invoke(null, new Object[0]);
                return TeaModel.adjustToModel((Map)o, (TeaModel)data);
            }
            catch (Exception e) {
                throw new TeaException(e.getMessage(), e);
            }
        }
        return TeaModel.confirmType(self, o);
    }

    private static Type getType(Field field, int index) {
        ParameterizedType genericType = (ParameterizedType)field.getGenericType();
        Type[] actualTypeArguments = genericType.getActualTypeArguments();
        Type actualTypeArgument = actualTypeArguments[index];
        return actualTypeArgument;
    }

    public static <T extends TeaModel> T toModel(Map<String, ?> map, T model) {
        T result = model;
        Map mapCopy = null;
        for (Field field : result.getClass().getDeclaredFields()) {
            Object value;
            NameInMap nameInMap;
            field.setAccessible(true);
            ParentIgnore parentIgnore = field.getAnnotation(ParentIgnore.class);
            mapCopy = map;
            if (parentIgnore != null) {
                String parent;
                String[] parents;
                String[] stringArray = parents = parentIgnore.value().split(",");
                int n = stringArray.length;
                for (int i = 0; i < n && (mapCopy = (Map)mapCopy.get(parent = stringArray[i])) != null; ++i) {
                }
            }
            String key = (nameInMap = field.getAnnotation(NameInMap.class)) == null ? field.getName() : nameInMap.value();
            Object v0 = value = mapCopy != null ? mapCopy.get(key) : null;
            if (value == null) continue;
            result = TeaModel.setTeaModelField(result, field, value, false);
        }
        return result;
    }

    public static <T extends TeaModel> T adjustToModel(Map<String, ?> map, T model) {
        T result = model;
        Map mapCopy = null;
        for (Field field : result.getClass().getDeclaredFields()) {
            Object value;
            NameInMap nameInMap;
            field.setAccessible(true);
            ParentIgnore parentIgnore = field.getAnnotation(ParentIgnore.class);
            mapCopy = map;
            if (parentIgnore != null) {
                String[] parents;
                for (String parent : parents = parentIgnore.value().split(",")) {
                    if (mapCopy.get(parent) == null || !Map.class.isAssignableFrom(mapCopy.get(parent).getClass())) {
                        mapCopy = null;
                        break;
                    }
                    mapCopy = (Map)mapCopy.get(parent);
                }
            }
            String key = (nameInMap = field.getAnnotation(NameInMap.class)) == null ? field.getName() : nameInMap.value();
            Object v0 = value = mapCopy != null ? mapCopy.get(key) : null;
            if (value == null) continue;
            result = TeaModel.setPrefixTeaModelField(result, field, value, false);
        }
        return result;
    }

    private static <T extends TeaModel> T setTeaModelField(T model, Field field, Object value, boolean userBuild) {
        try {
            Class<?> clazz = field.getType();
            Object resultValue = CommonUtil.parseNumber(value, clazz);
            T result = model;
            if (TeaModel.class.isAssignableFrom(clazz)) {
                Method method = clazz.getMethod("create", new Class[0]);
                Object data = method.invoke(null, new Object[0]);
                if (userBuild) {
                    field.set(result, TeaModel.build(TeaModel.toMap(resultValue, false), (TeaModel)data));
                } else if (!userBuild && Map.class.isAssignableFrom(resultValue.getClass())) {
                    field.set(result, TeaModel.toModel((Map)resultValue, (TeaModel)data));
                } else {
                    field.set(result, TeaModel.toModel(TeaModel.toMap(resultValue, false), (TeaModel)data));
                }
            } else if (Map.class.isAssignableFrom(clazz)) {
                boolean isUnmodifiableMap = false;
                try {
                    ((Map)resultValue).put(null, null);
                }
                catch (UnsupportedOperationException e) {
                    field.set(result, resultValue);
                    isUnmodifiableMap = true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!isUnmodifiableMap) {
                    ((Map)resultValue).remove(null);
                    field.set(result, TeaModel.buildObject(resultValue, Map.class, TeaModel.getType(field, 1)));
                }
            } else if (List.class.isAssignableFrom(clazz)) {
                field.set(result, TeaModel.buildObject(resultValue, List.class, TeaModel.getType(field, 0)));
            } else if (Enum.class.isAssignableFrom(clazz)) {
                Class<?> cl = Class.forName(clazz.getName());
                field.set(result, Enum.valueOf(cl, String.valueOf(resultValue).toUpperCase().replaceAll("-", "_")));
            } else {
                field.set(result, TeaModel.confirmType(clazz, resultValue));
            }
            return result;
        }
        catch (Exception e) {
            throw new TeaException(e.getMessage(), e);
        }
    }

    private static <T extends TeaModel> T setPrefixTeaModelField(T model, Field field, Object value, boolean userBuild) {
        try {
            Class<?> clazz = field.getType();
            Object resultValue = CommonUtil.parseNumber(value, clazz);
            T result = model;
            if (TeaModel.class.isAssignableFrom(clazz)) {
                Method method = clazz.getMethod("create", new Class[0]);
                Object data = method.invoke(null, new Object[0]);
                if (userBuild) {
                    field.set(result, TeaModel.build(TeaModel.toMap(resultValue, false), (TeaModel)data));
                } else if (!userBuild && Map.class.isAssignableFrom(resultValue.getClass())) {
                    field.set(result, TeaModel.adjustToModel((Map)resultValue, (TeaModel)data));
                } else {
                    field.set(result, TeaModel.adjustToModel(TeaModel.toMap(resultValue, false), (TeaModel)data));
                }
            } else if (Map.class.isAssignableFrom(clazz)) {
                boolean isUnmodifiableMap = false;
                try {
                    ((Map)resultValue).put(null, null);
                }
                catch (UnsupportedOperationException e) {
                    field.set(result, resultValue);
                    isUnmodifiableMap = true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!isUnmodifiableMap) {
                    ((Map)resultValue).remove(null);
                    field.set(result, TeaModel.buildPrefixObject(resultValue, Map.class, TeaModel.getType(field, 1)));
                }
            } else if (List.class.isAssignableFrom(clazz)) {
                field.set(result, TeaModel.buildPrefixObject(resultValue, List.class, TeaModel.getType(field, 0)));
            } else if (Enum.class.isAssignableFrom(clazz)) {
                Class<?> cl = Class.forName(clazz.getName());
                field.set(result, Enum.valueOf(cl, String.valueOf(resultValue).toUpperCase().replaceAll("-", "_")));
            } else {
                field.set(result, TeaModel.confirmType(clazz, resultValue));
            }
            return result;
        }
        catch (Exception e) {
            throw new TeaException(e.getMessage(), e);
        }
    }

    public static <T extends TeaModel> T build(Map<String, ?> map, T model) {
        T result = model;
        for (Field field : model.getClass().getDeclaredFields()) {
            NameInMap anno;
            field.setAccessible(true);
            String key = field.getName();
            Object value = map.get(key);
            if (value == null && (null == (anno = field.getAnnotation(NameInMap.class)) || null == (value = map.get(key = anno.value())))) continue;
            result = TeaModel.setTeaModelField(result, field, value, true);
        }
        return result;
    }

    public void validate() {
        Field[] fields = this.getClass().getDeclaredFields();
        try {
            for (int i = 0; i < fields.length; ++i) {
                fields[i].setAccessible(true);
                Object object = fields[i].get(this);
                Validation validation = fields[i].getAnnotation(Validation.class);
                boolean required = null != validation ? validation.required() : false;
                if (required && CommonUtil.isUnset(object)) {
                    throw new ValidateException("Field " + fields[i].getName() + " is required");
                }
                if (CommonUtil.isUnset(validation) || CommonUtil.isUnset(object)) continue;
                String pattern = validation.pattern();
                int maxLength = validation.maxLength();
                int minLength = validation.minLength();
                double maximum = validation.maximum();
                double minimum = validation.minimum();
                if ("".equals(pattern) && maxLength <= 0 && minLength <= 0 && maximum == Double.MAX_VALUE && minimum == Double.MIN_VALUE) continue;
                this.determineType(fields[i].getType(), object, pattern, maxLength, minLength, maximum, minimum, fields[i].getName());
            }
        }
        catch (Exception e) {
            throw new ValidateException(e.getMessage(), e);
        }
    }

    private void determineType(Class clazz, Object object, String pattern, int maxLength, int minLength, double maximum, double minimum, String fieldName) {
        if (Map.class.isAssignableFrom(clazz)) {
            this.validateMap(pattern, maxLength, minLength, maximum, minimum, (Map)object, fieldName);
        } else if (TeaModel.class.isAssignableFrom(clazz)) {
            ((TeaModel)object).validate();
        } else if (List.class.isAssignableFrom(clazz)) {
            List list = (List)object;
            for (int j = 0; j < list.size(); ++j) {
                this.determineType(list.get(j).getClass(), list.get(j), pattern, maxLength, minLength, maximum, minimum, fieldName);
            }
        } else if (clazz.isArray()) {
            Object[] objects = (Object[])object;
            for (int j = 0; j < objects.length; ++j) {
                this.determineType(clazz.getComponentType(), objects[j], pattern, maxLength, minLength, maximum, minimum, fieldName);
            }
        } else if (Number.class.isAssignableFrom(clazz)) {
            double value = Double.valueOf(object.toString());
            if (value > maximum) {
                throw new ValidateException(this.getClass().getName() + "." + fieldName + " exceeds the maximum");
            }
            if (value < minimum) {
                throw new ValidateException(this.getClass().getName() + "." + fieldName + " less than minimum");
            }
        } else {
            String value = String.valueOf(object);
            if (maxLength > 0 && value.length() > maxLength) {
                throw new ValidateException(this.getClass().getName() + "." + fieldName + " exceeds the maximum length");
            }
            if (minLength > 0 && value.length() < minLength) {
                throw new ValidateException(this.getClass().getName() + "." + fieldName + " less than minimum length");
            }
            if (!"".equals(pattern) && !Pattern.matches(pattern, value)) {
                throw new ValidateException(this.getClass().getName() + "." + fieldName + " regular match failed");
            }
        }
    }

    private void validateMap(String pattern, int maxLength, int minLength, double maximum, double minimum, Map<String, Object> map, String fieldName) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (CommonUtil.isUnset(entry.getValue())) continue;
            this.determineType(entry.getValue().getClass(), entry.getValue(), pattern, maxLength, minLength, maximum, minimum, fieldName);
        }
    }

    public static Map<String, Object> buildMap(TeaModel teaModel) {
        if (null == teaModel) {
            return null;
        }
        return teaModel.toMap();
    }

    public static void validateParams(TeaModel teaModel, String paramName) {
        if (null == teaModel) {
            throw new ValidateException("parameter " + paramName + " is not allowed as null");
        }
        teaModel.validate();
    }

    public static Object confirmType(Class expect, Object object) {
        if (String.class.isAssignableFrom(expect)) {
            if (object instanceof Number || object instanceof Boolean || object instanceof Map || object instanceof List) {
                return object.toString();
            }
        } else if (Boolean.class.isAssignableFrom(expect)) {
            if (object instanceof String) {
                return Boolean.parseBoolean(String.valueOf(object));
            }
            if (object instanceof Integer) {
                if (object.toString().equals("1")) {
                    return true;
                }
                if (object.toString().equals("0")) {
                    return false;
                }
            }
        } else if (Integer.class.isAssignableFrom(expect)) {
            if (object instanceof String) {
                try {
                    Integer.parseInt(object.toString());
                }
                catch (NumberFormatException e) {
                    logger.warning("There are some cast events happening. expect: {}, but: {}, value: {}.", new Object[]{Integer.class.getName(), object.getClass().getName(), object.toString()});
                }
                BigDecimal bigDecimal = new BigDecimal(object.toString());
                return bigDecimal.intValue();
            }
            if (object instanceof Boolean) {
                logger.warning("There are some cast events happening. expect: {}, but: {}, value: {}.", new Object[]{Integer.class.getName(), object.getClass().getName(), object.toString()});
                return object.toString().equalsIgnoreCase("true") ? 1 : 0;
            }
            if (object instanceof Long || object instanceof Float || object instanceof Double) {
                BigDecimal bigDecimal = new BigDecimal(object.toString());
                logger.warning("There are some cast events happening. expect: {}, but: {}, value: {}.", new Object[]{Integer.class.getName(), object.getClass().getName(), object.toString()});
                return bigDecimal.intValue();
            }
        } else if (Long.class.isAssignableFrom(expect)) {
            if (object instanceof String || object instanceof Integer) {
                try {
                    Integer.parseInt(object.toString());
                }
                catch (NumberFormatException e) {
                    logger.warning("There are some cast events happening. expect: {}, but: {}, value: {}.", new Object[]{Long.class.getName(), object.getClass().getName(), object.toString()});
                }
                BigDecimal bigDecimal = new BigDecimal(object.toString());
                return bigDecimal.longValue();
            }
            if (object instanceof Float || object instanceof Double) {
                BigDecimal bigDecimal = new BigDecimal(object.toString());
                logger.warning("There are some cast events happening. expect: {}, but: {}, value: {}.", new Object[]{Long.class.getName(), object.getClass().getName(), object.toString()});
                return bigDecimal.longValue();
            }
        } else if (Float.class.isAssignableFrom(expect)) {
            if (object instanceof String) {
                try {
                    Integer.parseInt(object.toString());
                }
                catch (NumberFormatException e) {
                    logger.warning("There are some cast events happening. expect: {}, but: {}, value: {}.", new Object[]{Float.class.getName(), object.getClass().getName(), object.toString()});
                }
                BigDecimal bigDecimal = new BigDecimal(object.toString());
                return Float.valueOf(bigDecimal.floatValue());
            }
            if (object instanceof Integer || object instanceof Long || object instanceof Double) {
                BigDecimal bigDecimal = new BigDecimal(object.toString());
                logger.warning("There are some cast events happening. expect: {}, but: {}, value: {}.", new Object[]{Float.class.getName(), object.getClass().getName(), object.toString()});
                return Float.valueOf(bigDecimal.floatValue());
            }
        } else if (Double.class.isAssignableFrom(expect)) {
            if (object instanceof String || object instanceof Float) {
                try {
                    Integer.parseInt(object.toString());
                }
                catch (NumberFormatException e) {
                    logger.warning("There are some cast events happening. expect: {}, but: {}, value: {}.", new Object[]{Double.class.getName(), object.getClass().getName(), object.toString()});
                }
                BigDecimal bigDecimal = new BigDecimal(object.toString());
                return bigDecimal.doubleValue();
            }
            if (object instanceof Integer || object instanceof Long) {
                BigDecimal bigDecimal = new BigDecimal(object.toString());
                logger.warning("There are some cast events happening. expect: {}, but: {}, value: {}.", new Object[]{Double.class.getName(), object.getClass().getName(), object.toString()});
                return bigDecimal.doubleValue();
            }
        }
        return object;
    }
}

