/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.jdbc;

import com.aliyun.odps.jdbc.OdpsConnection;
import com.aliyun.odps.jdbc.utils.ConnectionResource;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;

public class OdpsDriver
implements Driver {
    private static final boolean JDBC_COMPLIANT = false;

    public OdpsDriver() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkWrite("odps");
        }
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        return this.acceptsURL(url) ? new OdpsConnection(url, info) : null;
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        return ConnectionResource.acceptURL(url);
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        ConnectionResource connRes = new ConnectionResource(url, info);
        DriverPropertyInfo accessIdProp = new DriverPropertyInfo("access_id", connRes.getAccessId());
        accessIdProp.required = true;
        accessIdProp.description = "ODPS access id";
        DriverPropertyInfo accessKeyProp = new DriverPropertyInfo("access_key", connRes.getAccessKey());
        accessKeyProp.required = true;
        accessKeyProp.description = "ODPS access key";
        DriverPropertyInfo projectProp = new DriverPropertyInfo("project_name", connRes.getProject());
        projectProp.required = true;
        projectProp.description = "ODPS default project";
        DriverPropertyInfo charsetProp = new DriverPropertyInfo("charset", connRes.getCharset());
        charsetProp.required = false;
        charsetProp.description = "character set for the string type";
        charsetProp.choices = new String[]{"UTF-8", "GBK"};
        DriverPropertyInfo logviewProp = new DriverPropertyInfo("logview_host", connRes.getLogview());
        logviewProp.required = false;
        logviewProp.description = "logview host";
        return new DriverPropertyInfo[]{accessIdProp, accessKeyProp, projectProp, charsetProp};
    }

    @Override
    public int getMajorVersion() {
        return 0;
    }

    @Override
    public int getMinorVersion() {
        return 1;
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return Logger.getLogger("com.aliyun.odps.jdbc");
    }

    static {
        try {
            DriverManager.registerDriver(new OdpsDriver());
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

