/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.jdbc;

import com.aliyun.odps.data.Record;
import com.aliyun.odps.jdbc.OdpsResultSet;
import com.aliyun.odps.jdbc.OdpsResultSetMetaData;
import com.aliyun.odps.jdbc.OdpsStatement;
import com.aliyun.odps.tunnel.TableTunnel;
import com.aliyun.odps.tunnel.TunnelException;
import com.aliyun.odps.tunnel.io.TunnelRecordReader;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;

public class OdpsScollResultSet
extends OdpsResultSet
implements ResultSet {
    private TableTunnel.DownloadSession sessionHandle;
    private int fetchSize;
    private OdpsStatement.FetchDirection fetchDirection;
    private final long totalRows;
    private Object[][] rowsCache;
    private long cursorRow;
    private long cachedUpperRow;
    private boolean isClosed = false;

    OdpsScollResultSet(OdpsStatement stmt, OdpsResultSetMetaData meta, TableTunnel.DownloadSession session) throws SQLException {
        super(stmt.getConnection(), stmt, meta);
        this.sessionHandle = session;
        this.fetchSize = stmt.resultSetFetchSize;
        this.fetchDirection = stmt.resultSetFetchDirection;
        int maxRows = stmt.resultSetMaxRows;
        long recordCount = this.sessionHandle.getRecordCount();
        this.totalRows = maxRows > 0 && (long)maxRows <= recordCount ? (long)maxRows : recordCount;
        this.cachedUpperRow = this.totalRows;
        this.cursorRow = -1L;
        this.rowsCache = new Object[this.fetchSize][];
    }

    @Override
    public boolean absolute(int rows) throws SQLException {
        this.checkClosed();
        long target = rows >= 0 ? (long)rows : this.totalRows + (long)rows;
        long l = target = rows >= 0 ? target - 1L : target;
        if (target >= 0L && target < this.totalRows) {
            this.cursorRow = target;
            return true;
        }
        this.cursorRow = target < 0L ? -1L : this.totalRows;
        return false;
    }

    @Override
    public void afterLast() throws SQLException {
        this.checkClosed();
        this.cursorRow = this.totalRows;
    }

    protected void checkClosed() throws SQLException {
        if (this.isClosed) {
            throw new SQLException("The result set has been closed");
        }
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.checkClosed();
        this.cursorRow = -1L;
    }

    @Override
    public boolean first() throws SQLException {
        this.checkClosed();
        this.cursorRow = 0L;
        return this.totalRows > 0L;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        int direction;
        switch (this.fetchDirection) {
            case FORWARD: {
                direction = 1000;
                break;
            }
            case REVERSE: {
                direction = 1001;
                break;
            }
            default: {
                direction = 1002;
            }
        }
        return direction;
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.fetchSize = rows;
        this.rowsCache = new Object[this.fetchSize][];
        this.cachedUpperRow = this.totalRows;
    }

    @Override
    public int getRow() throws SQLException {
        this.checkClosed();
        return (int)this.cursorRow + 1;
    }

    @Override
    public int getType() throws SQLException {
        return 1004;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        this.checkClosed();
        return this.cursorRow == this.totalRows;
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        this.checkClosed();
        return this.cursorRow == -1L;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    @Override
    public boolean isFirst() throws SQLException {
        this.checkClosed();
        return this.cursorRow == 0L;
    }

    @Override
    public boolean isLast() throws SQLException {
        this.checkClosed();
        return this.cursorRow == this.totalRows - 1L;
    }

    @Override
    public boolean last() throws SQLException {
        this.checkClosed();
        this.cursorRow = this.totalRows - 1L;
        return this.totalRows > 0L;
    }

    @Override
    public boolean previous() throws SQLException {
        this.checkClosed();
        if (this.cursorRow != -1L) {
            --this.cursorRow;
        }
        return this.cursorRow != -1L;
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        this.checkClosed();
        long target = this.cursorRow + (long)rows;
        if (target >= 0L && target < this.totalRows) {
            this.cursorRow = target;
            return true;
        }
        this.cursorRow = target < 0L ? -1L : this.totalRows;
        return false;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        switch (direction) {
            case 1000: {
                this.fetchDirection = OdpsStatement.FetchDirection.FORWARD;
                break;
            }
            case 1001: {
                this.fetchDirection = OdpsStatement.FetchDirection.REVERSE;
                break;
            }
            case 1002: {
                this.fetchDirection = OdpsStatement.FetchDirection.UNKNOWN;
                break;
            }
            default: {
                throw new SQLException("invalid argument for setFetchDirection()");
            }
        }
        this.conn.log.info("setFetchDirection has not been utilized");
    }

    @Override
    public void close() throws SQLException {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        this.sessionHandle = null;
        this.rowsCache = null;
    }

    @Override
    public boolean next() throws SQLException {
        this.checkClosed();
        if (this.cursorRow != this.totalRows) {
            ++this.cursorRow;
        }
        return this.cursorRow != this.totalRows;
    }

    @Override
    protected Object[] rowAtCursor() throws SQLException {
        int offset;
        Object[] row;
        boolean cacheHit;
        boolean bl = cacheHit = this.cursorRow >= this.cachedUpperRow && this.cursorRow < this.cachedUpperRow + (long)this.fetchSize;
        if (!cacheHit) {
            this.fetchRows();
        }
        if ((row = this.rowsCache[offset = (int)(this.cursorRow - this.cachedUpperRow)]) == null) {
            throw new SQLException("the row should be not-null, row=" + this.cursorRow);
        }
        if (row.length == 0) {
            throw new SQLException("the row should have more than 1 column , row=" + this.cursorRow);
        }
        return row;
    }

    private void fetchRows() throws SQLException {
        this.cachedUpperRow = this.cursorRow / (long)this.fetchSize * (long)this.fetchSize;
        long count = this.fetchSize;
        if (this.cachedUpperRow + count > this.totalRows) {
            count = this.totalRows - this.cachedUpperRow;
        }
        try {
            long start = System.currentTimeMillis();
            Record reuseRecord = null;
            TunnelRecordReader reader = this.sessionHandle.openRecordReader(this.cachedUpperRow, count, true);
            int i = 0;
            while ((long)i < count) {
                reuseRecord = reader.read(reuseRecord);
                int columns = reuseRecord.getColumnCount();
                this.rowsCache[i] = new Object[columns];
                for (int j = 0; j < reuseRecord.getColumnCount(); ++j) {
                    this.rowsCache[i][j] = reuseRecord.get(j);
                }
                ++i;
            }
            long duration = System.currentTimeMillis() - start;
            long totalKBytes = reader.getTotalBytes() / 1024L;
            this.conn.log.fine(String.format("fetch records, start=%d, cnt=%d, %d KB, %.2f KB/s", this.cachedUpperRow, count, totalKBytes, Float.valueOf((float)totalKBytes / (float)duration * 1000.0f)));
            reader.close();
        }
        catch (TunnelException e) {
            throw new SQLException(e);
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
    }
}

