/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.jdbc.utils.transformer.to.jdbc;

import com.aliyun.odps.jdbc.utils.transformer.to.jdbc.AbstractToJdbcTransformer;
import java.sql.SQLException;

public class ToJdbcBooleanTransformer
extends AbstractToJdbcTransformer {
    @Override
    public Object transform(Object o, String charset) throws SQLException {
        if (o == null) {
            return false;
        }
        if (Boolean.class.isInstance(o)) {
            return o;
        }
        if (Number.class.isInstance(o)) {
            return ((Number)o).intValue() != 0;
        }
        if (o instanceof byte[]) {
            return !"0".equals(ToJdbcBooleanTransformer.encodeBytes((byte[])o, charset));
        }
        String errorMsg = ToJdbcBooleanTransformer.getInvalidTransformationErrorMsg(o.getClass(), Boolean.TYPE);
        throw new SQLException(errorMsg);
    }
}

