/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.jdbc.utils.transformer.to.jdbc;

import com.aliyun.odps.jdbc.utils.transformer.to.jdbc.AbstractToJdbcDateTypeTransformer;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class ToJdbcTimestampTransformer
extends AbstractToJdbcDateTypeTransformer {
    @Override
    public Object transform(Object o, String charset, Calendar cal, TimeZone timeZone) throws SQLException {
        if (o == null) {
            return null;
        }
        if (Date.class.isInstance(o)) {
            long time = ((Date)o).getTime();
            if (timeZone != null) {
                time += (long)timeZone.getOffset(time);
            }
            int nanos = 0;
            if (o instanceof Timestamp) {
                nanos = ((Timestamp)o).getNanos();
            }
            Timestamp ts = new Timestamp(time);
            ts.setNanos(nanos);
            return ts;
        }
        if (o instanceof ZonedDateTime) {
            if (timeZone != null) {
                o = ((ZonedDateTime)o).withZoneSameInstant(timeZone.toZoneId());
            }
            return Timestamp.valueOf(((ZonedDateTime)o).toLocalDateTime());
        }
        if (o instanceof Instant) {
            ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant((Instant)o, timeZone == null ? ((DateTimeFormatter)ZONED_DATETIME_FORMAT.get()).getZone() : timeZone.toZoneId());
            return Timestamp.valueOf(zonedDateTime.toLocalDateTime());
        }
        if (o instanceof byte[]) {
            try {
                String timestampStr;
                int dotIndex;
                SimpleDateFormat datetimeFormat = (SimpleDateFormat)DATETIME_FORMAT.get();
                if (cal != null) {
                    datetimeFormat.setCalendar(cal);
                }
                Date date = (dotIndex = (timestampStr = ToJdbcTimestampTransformer.encodeBytes((byte[])o, charset)).indexOf(46)) == -1 ? datetimeFormat.parse(timestampStr) : datetimeFormat.parse(timestampStr.substring(0, dotIndex));
                Timestamp timestamp = Timestamp.valueOf(timestampStr);
                int nanoValue = timestamp.getNanos();
                timestamp.setTime(date.getTime());
                timestamp.setNanos(nanoValue);
                Timestamp timestamp2 = timestamp;
                return timestamp2;
            }
            catch (IllegalArgumentException e) {
                String errorMsg = ToJdbcTimestampTransformer.getTransformationErrMsg(o, Timestamp.class);
                throw new SQLException(errorMsg);
            }
            catch (ParseException e) {
                String errorMsg = ToJdbcTimestampTransformer.getTransformationErrMsg(o, Timestamp.class);
                throw new SQLException(errorMsg);
            }
            finally {
                this.restoreToDefaultCalendar();
            }
        }
        String errorMsg = ToJdbcTimestampTransformer.getInvalidTransformationErrorMsg(o.getClass(), Timestamp.class);
        throw new SQLException(errorMsg);
    }
}

