/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.io;

import com.aliyun.odps.io.AbstractDatetimeWritable;
import com.aliyun.odps.io.WritableComparable;
import com.aliyun.odps.io.WritableComparator;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.Timestamp;

public class TimestampWritable
extends AbstractDatetimeWritable<TimestampWritable> {
    protected int nanos = 0;

    public TimestampWritable() {
    }

    public TimestampWritable(long time) {
        this(time / 1000L, (int)(time % 1000L) * 1000000);
    }

    public TimestampWritable(long seconds, int nanos) {
        this.set(seconds, nanos);
    }

    @Override
    public long get() {
        return this.value * 1000L + (long)(this.nanos / 1000000);
    }

    @Override
    public void set(long value) {
        super.set(value / 1000L);
        this.nanos = (int)(value % 1000L) * 1000000;
    }

    public long getTotalSeconds() {
        return this.value;
    }

    public int getNanos() {
        return this.nanos;
    }

    public Timestamp getTimestamp() {
        Timestamp ts = new Timestamp(this.value * 1000L);
        ts.setNanos(this.nanos);
        return ts;
    }

    public void setTimestamp(Timestamp ts) {
        this.set(ts.getTime() / 1000L, ts.getNanos());
    }

    public void set(long seconds, int nanos) {
        this.value = seconds + (long)(nanos / 1000000000);
        this.nanos = nanos % 1000000000;
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.value = in.readLong();
        this.nanos = in.readInt();
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeLong(this.value);
        out.writeInt(this.nanos);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TimestampWritable that = (TimestampWritable)o;
        return this.nanos == that.nanos;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.nanos;
        return result;
    }

    @Override
    public int compareTo(TimestampWritable o) {
        int ret = super.compareTo(o);
        if (ret != 0) {
            return ret;
        }
        return this.nanos < o.nanos ? -2 : (this.nanos == o.nanos ? 0 : 2);
    }

    @Override
    public String toString() {
        return this.getTimestamp().toString();
    }

    static {
        WritableComparator.define(TimestampWritable.class, new Comparator());
    }

    public static class DecreasingComparator
    extends Comparator {
        @Override
        public int compare(WritableComparable a, WritableComparable b) {
            return -super.compare(a, b);
        }

        @Override
        public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
            return -super.compare(b1, s1, l1, b2, s2, l2);
        }
    }

    public static class Comparator
    extends WritableComparator {
        public Comparator() {
            super(TimestampWritable.class);
        }

        @Override
        public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
            long thisValue = Comparator.readLong(b1, s1);
            int thisNano = Comparator.readInt(b1, s1 + 8);
            long thatValue = Comparator.readLong(b2, s2);
            int thatNano = Comparator.readInt(b2, s2 + 8);
            if (thisValue == thatValue) {
                return thisNano < thatNano ? -2 : (thisNano == thatNano ? 0 : 2);
            }
            return thisValue < thatValue ? -1 : 1;
        }
    }
}

