/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps;

import com.aliyun.odps.Job;
import com.aliyun.odps.LazyLoad;
import com.aliyun.odps.LogType;
import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.OdpsHooks;
import com.aliyun.odps.ReloadException;
import com.aliyun.odps.Task;
import com.aliyun.odps.commons.transport.Response;
import com.aliyun.odps.commons.util.DateUtils;
import com.aliyun.odps.commons.util.JacksonParser;
import com.aliyun.odps.rest.JAXBUtils;
import com.aliyun.odps.rest.ResourceBuilder;
import com.aliyun.odps.rest.RestClient;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBException;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlValue;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.commons.codec.binary.Base64;
import org.codehaus.jackson.map.ObjectMapper;

public class Instance
extends LazyLoad {
    private String project;
    private Map<String, Result> results;
    private boolean isSync = false;
    private TaskStatusModel model;
    private Status status;
    private RestClient client;
    private Odps odps;
    private boolean hookInvoked = false;
    private OdpsHooks hooks;

    Instance(String project, TaskStatusModel model, Map<String, Result> results, Odps odps) {
        this.project = project;
        this.model = model;
        this.results = results;
        if (model.status != null) {
            this.status = Status.valueOf(model.status.toUpperCase());
        }
        if (results != null && results.size() > 0) {
            this.isSync = true;
            this.status = Status.TERMINATED;
        }
        this.odps = odps;
        this.client = odps.getRestClient();
    }

    @Override
    public void reload() throws OdpsException {
        Response resp = this.client.request(this.getResource(), "GET", null, null, null);
        this.model.owner = resp.getHeaders().get("x-odps-owner");
        String startTimeStr = resp.getHeaders().get("x-odps-start-time");
        String endTimeStr = resp.getHeaders().get("x-odps-end-time");
        try {
            this.model.startTime = DateUtils.parseRfc822Date(startTimeStr);
        }
        catch (ParseException e) {
            throw new OdpsException("Invalid response, x-odps-start-time:" + startTimeStr);
        }
        try {
            this.model.endTime = DateUtils.parseRfc822Date(endTimeStr);
        }
        catch (ParseException e) {
            // empty catch block
        }
        try {
            InstanceStatusModel sm = JAXBUtils.unmarshal(resp, InstanceStatusModel.class);
            this.status = Status.valueOf(sm.status.toUpperCase());
        }
        catch (JAXBException e) {
            throw new OdpsException("Invalid instance status response.", e);
        }
    }

    public void stop() throws OdpsException {
        InstanceStatusModel sm = new InstanceStatusModel();
        sm.status = "Terminated";
        try {
            String ret = JAXBUtils.marshal(sm, InstanceStatusModel.class);
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Content-Type", "application/xml");
            this.client.stringRequest(this.getResource(), "PUT", null, headers, ret);
        }
        catch (Exception e) {
            throw new OdpsException(e.getMessage(), e);
        }
    }

    public Map<String, Result> getTaskResultsWithFormat() throws OdpsException {
        if (this.isSync) {
            return this.results;
        }
        this.results = new HashMap<String, Result>();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("result", null);
        InstanceResultModel rm = this.client.request(InstanceResultModel.class, this.getResource(), "GET", params);
        for (InstanceResultModel.TaskResult r : rm.taskResults) {
            this.results.put(r.name, r.result);
        }
        return this.results;
    }

    public Map<String, String> getTaskResults() throws OdpsException {
        Map<String, Result> results = this.getTaskResultsWithFormat();
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<String, Result> entry : results.entrySet()) {
            result.put(entry.getKey(), entry.getValue().getString());
        }
        return result;
    }

    public TaskSummary getTaskSummary(String taskName) throws OdpsException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("instancesummary", null);
        params.put("taskname", taskName);
        Response result = this.client.request(this.getResource(), "GET", params, null, null);
        TaskSummary summary = null;
        try {
            ObjectMapper objMapper = JacksonParser.getObjectMapper();
            Map map = (Map)objMapper.readValue(result.getBody(), Map.class);
            if (map.get("Instance") != null) {
                Map mapReduce = (Map)map.get("Instance");
                String jsonSummary = (String)mapReduce.get("JsonSummary");
                if (jsonSummary != null) {
                    summary = (TaskSummary)objMapper.readValue(jsonSummary, TaskSummary.class);
                }
                if (summary != null) {
                    summary.setSummaryText((String)mapReduce.get("Summary"));
                    summary.setJsonSummary(jsonSummary);
                }
            }
        }
        catch (Exception e) {
            return null;
        }
        return summary;
    }

    public Map<String, TaskStatus> getTaskStatus() throws OdpsException {
        HashMap<String, TaskStatus> taskStatus = new HashMap<String, TaskStatus>();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("taskstatus", null);
        TaskStatusModel resp = this.client.request(TaskStatusModel.class, this.getResource(), "GET", params);
        for (TaskStatusModel.InstanceTaskModel model : resp.tasks) {
            TaskStatus status = new TaskStatus(model);
            taskStatus.put(status.getName(), status);
        }
        return taskStatus;
    }

    public Set<String> getTaskNames() throws OdpsException {
        return this.getTaskStatus().keySet();
    }

    public boolean isSuccessful() throws OdpsException {
        boolean r = true;
        Map<String, TaskStatus> status = this.getTaskStatus();
        for (TaskStatus s : status.values()) {
            if (s.getStatus() == TaskStatus.Status.SUCCESS) continue;
            r = false;
            break;
        }
        return r;
    }

    public void waitForSuccess() throws OdpsException {
        this.waitForSuccess(1000L);
    }

    public void waitForSuccess(long interval) throws OdpsException {
        while (!this.isTerminated()) {
            try {
                Thread.sleep(interval);
            }
            catch (InterruptedException e) {
                // empty catch block
                break;
            }
        }
        if (!this.isSuccessful()) {
            for (Map.Entry<String, TaskStatus> e : this.getTaskStatus().entrySet()) {
                if (e.getValue().getStatus() == TaskStatus.Status.FAILED) {
                    throw new OdpsException(this.getTaskResults().get(e.getKey()));
                }
                if (e.getValue().getStatus() == TaskStatus.Status.SUCCESS) continue;
                throw new OdpsException(e.getKey() + ", Status=" + (Object)((Object)e.getValue().getStatus()));
            }
        }
    }

    public static String getStageProgressFormattedString(List<StageProgress> stages) {
        StringBuilder result = new StringBuilder();
        SimpleDateFormat sim = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String dateString = sim.format(new Date());
        result.append(dateString + ' ');
        for (StageProgress stage : stages) {
            result.append(String.format("%s:%s/%s/%s%s%s", stage.getName(), stage.getRunningWorkers(), stage.getTerminatedWorkers(), stage.getTotalWorkers(), stage.getBackupWorkers() > 0 ? "(+" + stage.getBackupWorkers() + " backups)" : "", "[" + stage.getFinishedPercentage() + "%]\t"));
        }
        return result.toString();
    }

    public List<StageProgress> getTaskProgress(String taskName) throws OdpsException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("instanceprogress", taskName);
        params.put("taskname", taskName);
        TaskProgress r = this.client.request(TaskProgress.class, this.getResource(), "GET", params);
        return r.getStages();
    }

    public String getId() {
        return this.model.name;
    }

    public Status getStatus() {
        if (this.status != Status.TERMINATED) {
            try {
                this.reload();
            }
            catch (OdpsException e) {
                throw new ReloadException(e.getMessage(), e);
            }
        }
        try {
            if (this.hooks != null && this.status == Status.TERMINATED && !this.hookInvoked) {
                this.hookInvoked = true;
                this.hooks.after(this, this.odps);
            }
        }
        catch (OdpsException e) {
            throw new ReloadException(e.getMessage(), e);
        }
        return this.status;
    }

    public boolean isTerminated() {
        return this.getStatus() == Status.TERMINATED;
    }

    public String getProject() {
        return this.project;
    }

    public boolean isSync() {
        return this.isSync;
    }

    public String getOwner() {
        if (this.model.owner == null) {
            this.lazyLoad();
        }
        return this.model.owner;
    }

    public Date getStartTime() {
        if (this.model.startTime == null) {
            this.lazyLoad();
        }
        return this.model.startTime;
    }

    public Date getEndTime() {
        if (this.model.endTime == null) {
            this.lazyLoad();
        }
        return this.model.endTime;
    }

    public List<Task> getTasks() throws OdpsException {
        String resource = this.getResource();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("source", null);
        Job.JobModel model = this.client.request(Job.JobModel.class, resource, "GET", params, null, null);
        Job job = new Job(model);
        return job.getTasks();
    }

    public int getPriority() throws OdpsException {
        String resource = this.getResource();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("source", null);
        Job.JobModel model = this.client.request(Job.JobModel.class, resource, "GET", params, null, null);
        Job job = new Job(model);
        return job.getPriority();
    }

    private String getResource() {
        return ResourceBuilder.buildInstanceResource(this.project, this.model.name);
    }

    public String getLog(String workerId, LogType logType, int size) throws OdpsException {
        if (workerId == null) {
            throw new OdpsException("Missing argument: workerId");
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("log", null);
        params.put("id", workerId);
        if (logType != null) {
            params.put("logtype", logType.toString());
        }
        if (size > 0) {
            params.put("size", String.valueOf(size));
        }
        Response resp = this.client.request(this.getResource(), "GET", params, null, null);
        return new String(resp.getBody());
    }

    public String getTaskDetailJson(String taskName) throws OdpsException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("instancedetail", null);
        params.put("taskname", taskName);
        Response result = this.client.request(this.getResource(), "GET", params, null, null);
        return new String(result.getBody());
    }

    public OdpsHooks getOdpsHooks() {
        return this.hooks;
    }

    public void setOdpsHooks(OdpsHooks hooks) {
        this.hooks = hooks;
    }

    public boolean isHookInvoked() {
        return this.hookInvoked;
    }

    public void setHookInvoked(boolean hookInvoked) {
        this.hookInvoked = hookInvoked;
    }

    public String getTaskDetailJson2(String taskName) throws OdpsException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("detail", null);
        params.put("taskname", taskName);
        Response result = this.client.request(this.getResource(), "GET", params, null, null);
        return new String(result.getBody());
    }

    @XmlRootElement(name="Progress")
    @XmlAccessorType(value=XmlAccessType.FIELD)
    private static class TaskProgress {
        @XmlElement(name="Stage")
        List<StageProgress> stages = new LinkedList<StageProgress>();

        private TaskProgress() {
        }

        List<StageProgress> getStages() {
            return this.stages;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class StageProgress {
        @XmlAttribute(name="ID")
        String name;
        @XmlElement(name="BackupWorkers")
        int backupSysInstances;
        @XmlElement(name="TerminatedWorkers")
        int terminatedSysInstances;
        @XmlElement(name="RunningWorkers")
        int runningSysInstances;
        @XmlElement(name="TotalWorkers")
        int totalSysInstances;
        @XmlElement(name="InputRecords")
        long inputRecords;
        @XmlElement(name="OutputRecords")
        long outputRecords;
        @XmlElement(name="FinishedPercentage")
        int finishedPercentage;

        public int getBackupWorkers() {
            return this.backupSysInstances;
        }

        public int getRunningWorkers() {
            return this.runningSysInstances;
        }

        public String getName() {
            return this.name;
        }

        public int getTerminatedWorkers() {
            return this.terminatedSysInstances;
        }

        public int getTotalWorkers() {
            return this.totalSysInstances;
        }

        public long getInputRecords() {
            return this.inputRecords;
        }

        public long getOutputRecords() {
            return this.outputRecords;
        }

        public int getFinishedPercentage() {
            return this.finishedPercentage;
        }
    }

    public static class TaskStatus {
        private TaskStatusModel.InstanceTaskModel model;

        TaskStatus(TaskStatusModel.InstanceTaskModel model) {
            this.model = model;
        }

        public String getName() {
            return this.model.name;
        }

        public String getType() {
            return this.model.type;
        }

        public Status getStatus() {
            return Status.valueOf(this.model.status.toUpperCase());
        }

        public static enum Status {
            WAITING,
            RUNNING,
            SUCCESS,
            FAILED,
            SUSPENDED,
            CANCELLED;

        }
    }

    @XmlRootElement(name="Instance")
    static class TaskStatusModel {
        @XmlElement(name="Name")
        String name;
        @XmlElement(name="Owner")
        String owner;
        @XmlElement(name="StartTime")
        @XmlJavaTypeAdapter(value=JAXBUtils.DateBinding.class)
        Date startTime;
        @XmlElement(name="EndTime")
        @XmlJavaTypeAdapter(value=JAXBUtils.DateBinding.class)
        Date endTime;
        @XmlElement(name="Status")
        String status;
        @XmlElementWrapper(name="Tasks")
        @XmlElement(name="Task")
        List<InstanceTaskModel> tasks = new ArrayList<InstanceTaskModel>();

        TaskStatusModel() {
        }

        static class InstanceTaskModel {
            @XmlElement(name="Name")
            String name;
            @XmlAttribute(name="Type")
            String type;
            @XmlElement(name="StartTime")
            @XmlJavaTypeAdapter(value=JAXBUtils.DateBinding.class)
            Date startTime;
            @XmlElement(name="EndTime")
            @XmlJavaTypeAdapter(value=JAXBUtils.DateBinding.class)
            Date endTime;
            @XmlElement(name="Status")
            String status;
            @XmlElementWrapper(name="Histories")
            @XmlElement(name="History")
            List<InstanceTaskModel> histories = new ArrayList<InstanceTaskModel>();

            InstanceTaskModel() {
            }
        }
    }

    public static class TaskSummary
    extends HashMap {
        private String text;
        private String jsonSummary = "{}";

        public String getSummaryText() {
            return this.text;
        }

        void setSummaryText(String text) {
            this.text = text;
        }

        public String getJsonSummary() {
            return this.jsonSummary;
        }

        void setJsonSummary(String jsonSummary) {
            this.jsonSummary = jsonSummary;
        }
    }

    @XmlRootElement
    public static class Result {
        @XmlAttribute(name="Transform")
        String transform;
        @XmlAttribute(name="Format")
        String format;
        @XmlValue
        String text;

        public String getString() {
            if (this.transform != null && "Base64".equals(this.transform)) {
                try {
                    String decodedString = new String(Base64.decodeBase64((String)this.text), "UTF-8");
                    return decodedString;
                }
                catch (Exception e) {
                    return this.text;
                }
            }
            return this.text;
        }

        public String getFormat() {
            return this.format;
        }
    }

    @XmlRootElement(name="Instance")
    static class InstanceResultModel {
        @XmlElementWrapper(name="Tasks")
        @XmlElement(name="Task")
        List<TaskResult> taskResults = new ArrayList<TaskResult>();

        InstanceResultModel() {
        }

        static class TaskResult {
            @XmlAttribute(name="Type")
            String type;
            @XmlElement(name="Name")
            String name;
            @XmlElement(name="Result")
            Result result;

            TaskResult() {
            }
        }
    }

    @XmlRootElement(name="Instance")
    private static class InstanceStatusModel {
        @XmlElement(name="Status")
        String status;

        private InstanceStatusModel() {
        }
    }

    public static enum Status {
        RUNNING("Running"),
        SUSPENDED("Suspended"),
        TERMINATED("Terminated");

        private static final Map<String, Status> strToEnum;
        private String strVal;

        private Status(String strVal) {
            this.strVal = strVal;
        }

        static Status fromString(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            return strToEnum.get(value);
        }

        public String toString() {
            return this.strVal;
        }

        static {
            strToEnum = new HashMap<String, Status>();
            for (Status t : Status.values()) {
                strToEnum.put(t.toString(), t);
            }
        }
    }
}

